package edu.buffalo.nsf.hippo.data.tuple;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import edu.buffalo.nsf.hippo.util.Stats;
import edu.buffalo.nsf.hippo.util.StatsManager;
import edu.buffalo.nsf.hippo.util.Util;

public class ListTupleStream extends TupleStream
{
    protected TupleMetaData metaData;
    
    protected List          rows;
    protected int           currentRow;

    public ListTupleStream(List rows, TupleMetaData metaData)
    {
        this.rows       = Util.toList(rows);
        this.metaData   = metaData;

        this.currentRow = -1;
    }
        
    public ListTupleStream(ResultSet rs) throws SQLException
    {
        this(rs,TupleMetaData.create(rs.getMetaData()));
    }

    public ListTupleStream(ResultSet rs, TupleMetaData metaData) throws SQLException
    {
        int fieldCount = metaData.getFieldCount();
            
        this.metaData  = metaData;
        this.rows      = Util.createList();
            
        while (rs.next()) {
                
            Object[] row = new Object[fieldCount];
                
            for (int j = 0; j < fieldCount; j++) {

                row[j] = rs.getObject(j+1);

                if (rs.wasNull()) {
                    row[j] = null;
                }
            }

            rows.add(Tuple.create(row));
        }

        StatsManager.peekStats().touch(Stats.TUPLES_FROM_DB,
                                       (double) rows.size());

        currentRow = -1;
    }

    public TupleMetaData getMetaData()
    {
        return metaData;
    }
        
    public boolean hasNext()
    {
        if (currentRow + 1 < rows.size()) {
            return true;
        } else {
            return false;
        }
    }
        
    public Tuple getNext()
    {
        if (currentRow >= rows.size()) {
            return null;
        }
            
        return (Tuple) rows.get(++currentRow);
    }
        
    public String toString()
    {
        return "TS(" + metaData + ")[#" + rows.size() + "]";
    }
}
