package edu.buffalo.nsf.hippo.data.tuple;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.util.Util;

public class SQLTupleStream extends TupleStream
{
    protected static Logger logger = Logger.getLogger(SQLTupleStream.class);

    protected TupleMetaData metaData;
    protected boolean   hasNext;
    
    protected Tuple     next;
    protected ResultSet rs;
    protected Statement stmt;
    
    public SQLTupleStream(ResultSet rs, Statement stmt) throws SQLException
    {
        this(rs,stmt,TupleMetaData.create(rs.getMetaData()));
    }

    public SQLTupleStream(ResultSet rs, Statement stmt, TupleMetaData metaData)
    {
        this.hasNext = true;
        this.metaData = metaData;
        this.rs = rs;
        this.stmt = stmt;
        this.next = next();
    }


    protected void close()
    {
        try {
            rs.close();
            stmt.close();
        } catch (Throwable t) {
            logger.error("Throwable caught while closing SQLTupleStream.",t);
        }
    }

    protected void finalize()
    {
        close();
    }

    protected Tuple readTuple(ResultSet rs, int fieldCount)
    {
        try {

            Object[] row = new Object[fieldCount];
            
            for (int i = 0; i < fieldCount; i++) {
                row[i] = rs.getObject(i+1);
                
                if (rs.wasNull()) {
                    row[i] = null;
                }
            }
            
            //StatsManager.peekStats().touch(Stats.TUPLES_FROM_DB);

            return Tuple.create(row);        
        } catch (SQLException exc) {
            logger.error("Exception caught.",exc);
            throw new TupleStreamError("Exception caught.",exc);
        }

    }

    protected Tuple next() 
    {
        try {
            if (hasNext) {
                if (rs.next()) {
                    return readTuple(rs,metaData.getFieldCount());
                } else {
                    hasNext = false;
                    close();
                }
            }

            return null;

        } catch (SQLException exc) {            
            logger.error("Exception caught.",exc);
            throw new TupleStreamError("Exception caught.",exc);
        }
    }

    public TupleMetaData getMetaData()
    {
        return metaData;
    }
        
    public boolean hasNext()
    {
        return hasNext;
    }
        
    public Tuple getNext()
    {
        Tuple result = next;
        
        next = next();

        return result;
    }
        
    public String toString()
    {
        return "SQL-TS(" + metaData + ")" + "[#" + Util.getTupleCount(rs) + "]";
    }
}
