package edu.buffalo.nsf.hippo.net;

import java.net.ServerSocket;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.util.Util;

public final class RunServer
{
    static {
        Util.setUpLogger(Level.DEBUG);
    }

    protected static Logger logger = Logger.getLogger(RunServer.class);
    
    public static void main(String[] args) throws Throwable
    {

        ServerManager mgr = new ServerManager("Hippo server");        
        int port = 0;

        synchronized (mgr) {
            for (int i = 0; i < args.length - 1; i += 2) {
                try {
                    port       = Integer.parseInt(args[i]);
                    String configFile = args[i+1];
                    
                    mgr.deployServer(port,configFile);
                    
                } catch (Throwable t) {
                    logger.error("Exception caught while registering server on " + port,t);
                }
            }
            mgr.list();

            ServerSocket k = new ServerSocket(4000);

            k.accept();

            logger.info("intrrupting the server manager");

            mgr.interrupt();

            mgr.shutdown();
        }

    }
}
