package edu.buffalo.nsf.hippo.net;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;

public class Server extends Thread
{
    protected Logger        logger;

    protected ServerManager parent;
    protected Environment   env;
    protected Engine        e;
    protected ServerSocket  listener;
    protected boolean       active = true;

    public Server (ServerManager parent, int port, Configuration config)
        throws IOException
    {
        super(parent,buildName(port,config));

        this.logger = Logger.getLogger(getName());

        logger.info("Starting server: " + getName());

        this.env    = parent.getEnvironment();
        this.e      = env.getEngine(config);

        this.listener = new ServerSocket(port);
        this.listener.setSoTimeout(10);

        logger.info("Server running: " + getName());
    }

    protected static String buildName(int port, Configuration config)
    {
        String dbName          = config.getDBName();

        String fullEngineName  = config.getEngineName();
        String engineName = fullEngineName.substring(fullEngineName.lastIndexOf('.') + 1);
        String fullProverName  = config.getProverFactoryName();
        String proverName      = null;
        if (fullProverName != null) {
            proverName      = fullProverName.substring(fullProverName.lastIndexOf('.')+1);
        }

        return "Server [" + dbName + " : " + engineName +
            ((proverName != null)?("(" + proverName + ")"):("")) + " : " + port + "]";
    }

    public ServerManager getParent()
    {
        return (ServerManager) getThreadGroup();
    }
    

    public void run()
    {
        while (active) {
            try {
                listen();
                
            } catch(InterruptedIOException exc) {
                //logger.info("Server interrupted.",exc);
                //shutdown();
                //break;
            } catch(Throwable t) {
                logger.error("Caught exception.",t);                    
            }
        }
    }

    public void interrupt()
    {
        logger.debug("interrupting the thread.");
        active = false;
        try {
            listener.close();
        } catch (Throwable t) {
            logger.debug("Exception caught while closing the socket.",t);
        }
        super.interrupt();
    }

    public void listen()
        throws Exception
    {
        Socket receiver = listener.accept();
        
        logger.debug("Receiving transmition...: " + receiver);

        process(receiver);

        receiver.close();
    }

    public void process(Socket receiver)
        throws Exception
    {
        Reader in       = new InputStreamReader(receiver.getInputStream());
        Writer out      = new OutputStreamWriter(receiver.getOutputStream());
        String query    = "";
        int    ch       = 0;

        do {
            if ((ch = in.read()) == -1) {
                break;
            }
            query += (char) ch;
        } while (ch != ';');

        logger.debug("received the query:" + query);
        
        String result ="";
        try {
            TupleStream ts = e.getConsistentAnswer(query);
            int i = 0;
            while (ts.hasNext()) {
                i++;
                Tuple t = ts.getNext();
                StringBuffer tmp = new StringBuffer();

                for (int j=0; j < t.getFieldCount(); j++) {
                    tmp.append(t.getObject(j));
                /** Perhaps something else should be done here with this tuple.**/
                }

            }
            result = ""+i;
        } catch (Throwable t) {
            result = "Exception caught while processiong the query.\n";
            StringWriter s = new StringWriter();
            t.printStackTrace(new PrintWriter(s,true));
            result += s.toString();
        }
        out.write(result);
        out.flush();

        out.close();
        
        Runtime.getRuntime().gc();
    }

    public void shutdown()
    {
        try {
            logger.debug("shutting down");
            env.dispose(e);
            listener.close();
        } catch (Exception exc) {
            logger.error("Caught exception while shutdown.", exc);
        }
    }
}
