package edu.buffalo.nsf.hippo.prolog;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.OuterJoin;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTransformer;
import edu.buffalo.nsf.hippo.data.tuple.TupleFilter;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.parser.ParseException;

public class CoreProverEngine extends AbstractProverEngine 
{
    protected Logger logger = Logger.getLogger(CoreProverEngine.class);

    protected QueryTransformer f;
    protected QueryTransformer g;

    public CoreProverEngine(Environment env)
    {
        super(env);
    }

    public void init(Configuration config)
    {
        super.init(config);
        this.f = env.getEnvelopeOperator(config);
        this.g = env.getCoreOperator(config);
    }

    public void shutdown()
    {
        env.dispose(f);
        env.dispose(g);
        super.shutdown();
    }



    public TupleStream getConsistentAnswer(String sqlQuery) throws ParseException
    {
        //logger.info("Processing query:" + sqlQuery);
        
        Query            q = parseQuery(sqlQuery);

        Query            gq = g.transform(q);
        TupleStream    core = source.executeQuery(gq);

        Query            fq = f.transform(q);

        if (fq instanceof OuterJoin) {
            OuterJoin Fq = (OuterJoin) fq;

            Query rq = new OuterJoin(new Difference(Fq.query,gq),Fq.length, Fq.rel,Fq.offset);
            Query sq = new OuterJoin(q,Fq.length,Fq.rel,Fq.offset);
            Prover p = factory.create(sq);
            TupleFilter pf = new ProverTupleFilter(p,ri);

            TupleStream rest   = TupleStream.filter(pf,source.executeQuery(rq));
            TupleStream trest  = TupleStream.trim(rest,Fq.length);

            TupleStream result = TupleStream.concatenate(core,trest);

            return result;
        } else {
            Query            rq = new Difference(fq,gq);

            Prover           p = factory.create(q); 
            TupleFilter     pf = new ProverTupleFilter(p,ri);

            TupleStream   rest = TupleStream.filter(pf,source.executeQuery(rq));
            TupleStream result = TupleStream.concatenate(core,rest);

            return result;
        }
    }
}
