package edu.buffalo.nsf.hippo.prolog;

import edu.buffalo.nsf.hippo.data.DataSourceCache;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;

public class Elaboration
{
    public static final Object U  = new String("Unknown");
    public static final Object T  = new String("True");
    public static final Object F  = new String("False");

    public static final Elaboration UNKNOWN = new Elaboration(U);
    public static final Elaboration TRUE    = new Elaboration(T);
    public static final Elaboration FALSE   = new Elaboration(F);

    protected Object          result;
    protected DataSourceCache cache;
    protected Hypergraph      h;

    public Elaboration(Object result)
    {
        this.result = result;
    }

    public Elaboration(Object result, DataSourceCache cache)
    {
        this(result);
        this.cache = cache;
    }

    public Elaboration(Object result, Hypergraph h)
    {
        this(result);
        this.h = h;
    }


    public static Elaboration create(boolean b)
    {
        if (b) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public static Elaboration create(Object s)
    {
        if (s.equals(T)) {
            return TRUE;
        } else if (s.equals(F)) {
            return FALSE;
        } else {
            return UNKNOWN;
        }
    }

    public Object getResult()
    {
        return result;
    }

    public DataSourceCache getDataSourceCache()
    {
        return cache;
    }

    public Hypergraph getHypergraph()
    {
        return h;
    }

    public boolean isTrue()
    {
        return result == T;
    }

    public boolean isFalse()
    {
        return result == F;
    }

    public boolean isUnknown()
    {
        return result == U;
    }

    public String toString()
    {
        return result.toString();
    }
        
}

//     public static Elaboration and(Elaboration e1, Elaboration e2)
//     {
//         if (e1 == TRUE && e2 == TRUE) {
//             return TRUE;
//         } else if (e1 == FALSE || e2 == FALSE){
//             return FALSE;
//         } else {
//             return UNKNOWN;
//         }
//     }

//     public static Elaboration not(Elaboration e)
//     {
//         if (e == TRUE) {
//             return FALSE;
//         } else if (e == FALSE) {
//             return TRUE;
//         } else {
//             return UNKNOWN;
//         }
//     }

//     public static Elaboration or(Elaboration e1, Elaboration e2)
//     {
//         return not(and(not(e1),not(e2)));
//     }

//     public static Elaboration or(Elaboration e1, Elaboration e2, Elaboration e3)
//     {
//         return or(or(e1,e2),e3);
//     }

//     public static Elaboration and(Elaboration[] e)
//     {
//         Elaboration result = TRUE;

//         for (int i = 0; i < e.length; i++) {
//             result = and(result,e[i]);
//         }

//         return result;
//     }

//     public static Elaboration or(Elaboration[] e)
//     {
//         Elaboration result = FALSE;
        
//         for(int i = 0; i < e.length; i++) {
//             result = or(result,e[i]);
//         }
        
//         return result;
//     }

