package edu.buffalo.nsf.hippo.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.io.File;

import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.WindowConstants;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBException;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.EnvironmentImpl;
import edu.buffalo.nsf.hippo.XMLConfiguration;
import edu.buffalo.nsf.hippo.util.Util;


/**
* This code was generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* *************************************
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED
* for this machine, so Jigloo or this code cannot be used legally
* for any corporate or commercial purpose.
* *************************************
*/
public class HippoApp extends javax.swing.JFrame implements ActionListener {

	private static final long serialVersionUID = -2140388407458976906L;
	private static Logger logger = Logger.getLogger(HippoApp.class);
	
	
	{
		Util.setUpLogger();
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch(Exception e) {
			e.printStackTrace();
		}
	}


	private JMenuItem helpMenuItem;
	private JMenu helpMenu;
	private JMenuItem deleteMenuItem;
	private JSeparator jSeparator1;
	private JMenuItem pasteMenuItem;
	private JMenuItem aboutMenuItem;
	private JMenuItem copyMenuItem;
	private JMenuItem cutMenuItem;
	private JMenu editMenu;
	private JMenuItem exitMenuItem;
	private JSeparator jSeparator2;
	private JMenuItem closeFileMenuItem;
	private JMenuItem saveAsMenuItem;
	private JMenuItem saveMenuItem;
	private JMenuItem openFileMenuItem;
	private JMenuItem newFileMenuItem;
	private JMenu connectionMenu;
	private JTextArea queryInputTextArea1;
	private JSeparator jSeparator3;
	private JMenuBar mainMenu;
	private JFileChooser configFileDialog;
	private FileFilter configFileFilter;
	private Environment env;
	private JDesktopPane desktopPane;
	private QueryHistory queryHistory;

	/**
	* Auto-generated main method to display this JFrame
	*/
	public static void main(String[] args) {
		HippoApp inst = new HippoApp();
		inst.setVisible(true);
	}
	
	public HippoApp() {
		super();
		this.env = new EnvironmentImpl();
		initGUI();
		configFileDialog = new JFileChooser();
		this.queryHistory = new QueryHistory(3);
	}
	
	private void initGUI() {
		try {
			setSize(800, 600);
			this.setTitle("Hippo 0.9");
			this.setIconImage(null);
			this.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
			this.addWindowListener(new WindowAdapter() {
				public void windowClosed(WindowEvent evt) {
					rootWindowClosed(evt);
				}
				public void windowClosing(WindowEvent evt) {
					rootWindowClosing(evt);
				}
			});
			this.setDefaultCloseOperation(EXIT_ON_CLOSE);
			{
				mainMenu = new JMenuBar();
				setJMenuBar(mainMenu);
				{
					connectionMenu = new JMenu();
					mainMenu.add(connectionMenu);
					connectionMenu.setText("Connection");
					{
						openFileMenuItem = new JMenuItem();
						connectionMenu.add(openFileMenuItem);
						openFileMenuItem.setText("Open");
						openFileMenuItem.addActionListener(this);
					}
					{
						closeFileMenuItem = new JMenuItem();
						connectionMenu.add(closeFileMenuItem);
						closeFileMenuItem.setText("Close");
					}
					{
						jSeparator2 = new JSeparator();
						connectionMenu.add(jSeparator2);
					}
					{
						exitMenuItem = new JMenuItem();
						connectionMenu.add(exitMenuItem);
						exitMenuItem.setText("Exit");
						exitMenuItem.addActionListener(new ActionListener() {
							public void actionPerformed(ActionEvent evt) {
								exitMenuItemActionPerformed(evt);
							}
						});
					}
				}
				{
					editMenu = new JMenu();
					mainMenu.add(editMenu);
					editMenu.setText("Edit");
					{
						cutMenuItem = new JMenuItem();
						editMenu.add(cutMenuItem);
						cutMenuItem.setText("Cut");
					}
					{
						copyMenuItem = new JMenuItem();
						editMenu.add(copyMenuItem);
						copyMenuItem.setText("Copy");
					}
					{
						pasteMenuItem = new JMenuItem();
						editMenu.add(pasteMenuItem);
						pasteMenuItem.setText("Paste");
					}
					{
						jSeparator1 = new JSeparator();
						editMenu.add(jSeparator1);
					}
					{
						deleteMenuItem = new JMenuItem();
						editMenu.add(deleteMenuItem);
						deleteMenuItem.setText("Delete");
					}
				}
				mainMenu.add(Box.createHorizontalGlue());
				{
					helpMenu = new JMenu();
					mainMenu.add(helpMenu);
					helpMenu.setText("Help");
					{
						helpMenuItem = new JMenuItem();
						helpMenu.add(helpMenuItem);
						helpMenuItem.setText("Help");
					}
					{
						jSeparator3 = new JSeparator();
						helpMenu.add(jSeparator3);
					}
					{
						aboutMenuItem = new JMenuItem();
						helpMenu.add(aboutMenuItem);
						aboutMenuItem.setText("About");
					}
				}
				{
					desktopPane = new JDesktopPane();
					this.setContentPane(desktopPane);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}	

	/** Returns an ImageIcon, or null if the path was invalid. */
    protected static ImageIcon createImageIcon(String path) {
        java.net.URL imgURL = HippoApp.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        } else {
            System.err.println("Couldn't find file: " + path);
            return null;
        }
    }

	public void actionPerformed(ActionEvent event) {
		System.out.println("action event:" + event);
		if (event.getSource() == openFileMenuItem) {
			openCmd();
		} 
	}
	
	public void openCmd() {
		int ret = configFileDialog.showOpenDialog(this);
		System.out.println("return value:" + ret);
		if (ret == JFileChooser.APPROVE_OPTION) {
			System.out.println("Selected file:" + configFileDialog.getSelectedFile());
			File configFile = configFileDialog.getSelectedFile();
			
			Configuration config;
			try {
				config = new XMLConfiguration(configFile);
				JInternalFrame session = new SessionFrame(config,env,queryHistory);
				session.setVisible(true);
				desktopPane.add(session);
				session.setSelected(true);
			} catch (JAXBException e) {
				logger.error("Error reading configuration file: " + configFile,e);
				JOptionPane.showMessageDialog(this,
				    "Error reading the configuration file. \n" +
					"You can find details in the log file.",
				    "Parse Error",
				    JOptionPane.ERROR_MESSAGE);
			} catch (PropertyVetoException e1) {}
		}	
	}
	
	private void exitMenuItemActionPerformed(ActionEvent evt) {
		this.processWindowEvent(new WindowEvent(this,WindowEvent.WINDOW_CLOSING));
	}
	
	private void rootWindowClosing(WindowEvent evt) {
		this.env.shutdown();
	}
	
	private void rootWindowClosed(WindowEvent evt) {
System.out.println("this.windowClosed, event="+evt);
//TODO add your code for this.windowClosed
	}
}
