package edu.buffalo.nsf.hippo.util;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleMetaData;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
// import edu.buffalo.nsf.hippo.data.config.Schema;
// import edu.buffalo.nsf.hippo.data.config.Relation;
// import edu.buffalo.nsf.hippo.data.config.Configuration;
// import edu.buffalo.nsf.hippo.data.config.DbDescription;


/**
 *  This class is a container of miscellaneous functions 
 *  often used in other parts of application.
 */
public final class FormatUtil
{
    private static Logger logger = Logger.getLogger(FormatUtil.class);



    protected static String __buffer = "        ";
    protected static int    __length = __buffer.length();

    protected static String __format(String str)
    {
        StringBuffer b = new StringBuffer(__buffer);       
        

        return b.replace(__length - str.length(), __length,str).toString();
    }
    
    protected static String __fill(char ch)
    {
        return __buffer.replace(' ',ch);
    }


    public static String txtFormat(TupleStream ts)
    {
        int fieldCount = ts.getMetaData().getFieldCount();
        StringBuffer result = new StringBuffer();

        for (int i = 0; i < fieldCount; i++) {
            result.append(__format(ts.getMetaData().getFieldName(i)));
            if (i < fieldCount - 1) {
                result.append(" | ");
            } else {
                result.append(" \n");
            }
        }

        for (int i = 0; i < fieldCount; i++) {
            result.append(__fill('-'));
            if (i < fieldCount - 1) {
                result.append("-+-");
            } else {
                result.append("-\n");
            }
        }

        int j = 0;
        while (ts.hasNext()) {
            Tuple t = ts.getNext();
            for (int i = 0; i < fieldCount; i++) {                
                result.append(__format(""+t.getObject(i)));
                if (i < fieldCount - 1) {
                    result.append(" | ");
                } else {
                    result.append(" \n");
                }
            }
            j++;
        }

        result.append("(").append(j).append(' ');
        result.append((j == 1) ? ("tuple"):("tuples")).append(")\n\n");
        
        return result.toString();
    }

    public static String xmlFormat(TupleStream ts, String query)
    {
        String result = "<tuple-stream>\n";

        if (query != null) {
            result += "<query>" + escapeXML(query) + "</query>\n";
        }

        result += xmlFormat(ts.getMetaData()) +"\n";
        
        result += "<tuples>\n";
        while (ts.hasNext()) {
            result += xmlFormat(ts.getNext()) + "\n";
        }
        result += "</tuples>\n";

        result += "</tuple-stream>";

        return result;
    }
    
    public static String xmlFormat(TupleMetaData metaData)
    {
        String result = "<meta-data>\n";

        for (int i = 0; i < metaData.getFieldCount(); i++) {
            result+="<field " + 
                " name=\"" + 
                   escapeXML(metaData.getFieldName(i)) +
                "\" " +
                " type=\"" + 
                   escapeXML(metaData.getFieldTypeName(i)) +
                "\"/>";
        }

        result += "</meta-data>";

        return result;
    }

    public static String xmlFormat(Tuple t)
    {
        String result = "<tuple>\n";

        for (int i = 0; i < t.getFieldCount(); i++) {
            result+="<field " + 
                " value=\"" + escapeXML(t.getObject(i).toString())+ "\"/>";
        }

        result += "</tuple>";

        return result;
    }

 
    public static String escapeXML(String string)
    {
        char[] array = string.toCharArray();
        StringBuffer buffer = new StringBuffer();

        for (int i = 0; i < array.length; i++) {
            switch (array[i]) {
            case '<':
                buffer.append("&lt;");
                break;
            case '>':
                    buffer.append("&gt;");
                break;
            case '&':
                buffer.append("&amp;");
                break;
            case '"':
                buffer.append("&quot;");
                break;
            case '\'':
                buffer.append("&apos;");
                break;
            default:
                buffer.append(array[i]);
                break;
            }
        }

        return buffer.toString();
    }

    public static String escapeSQL(String st)
    {
        char[] array = st.toCharArray();
        StringBuffer buffer = new StringBuffer();

        for (int i = 0; i < array.length; i++) {
            switch (array[i]) {
            case '\\':
                buffer.append("\\\\");
                break;
            case '\'':
                buffer.append("\\\'");
                break;
            case '\"':
                    buffer.append("\\\"");
                break;
            case '\n':
                buffer.append("\\n");
                break;
            case '\r':
                buffer.append("\\r");
                break;
            default:
                buffer.append(array[i]);
                break;
            }
        }

        return buffer.toString();
    }

    public static String escapeSQLString(String st)
    {
        return "'" + escapeSQL(st) + "'";
    }

    public static String parseSQL(String st)
    {
        char[]       array  = st.toCharArray();
        StringBuffer buffer = new StringBuffer();

        int i = 0;

        while (i < array.length) {
            switch (array[i]) {
            case '\\':
                switch (array[++i]) {
                case '\'':
                    buffer.append('\'');
                    break;
                case '\"':
                    buffer.append('\"');
                    break;
                case 'n':
                    buffer.append('\n');
                    break;
                case 'r':
                    buffer.append('\r');
                    break;                    
                default:
                    logger.warn("Unknown escape sequence \\" + array[i] + ".");
                    buffer.append('\'').append(array[i]);
                    break;
                }
                break;
            default:
                buffer.append(array[i]);
                break;
            }
            i++;
        }

        return buffer.toString();
    }

    public static String parseSQLString(String st)
    {
        return parseSQL(st.substring(1,st.length() - 1));
    }
}
