package edu.buffalo.nsf.hippo.util;

import java.util.Hashtable;
import java.util.Stack;

import org.apache.log4j.Logger;

/**
 *
 */
public class StatsManager
{
    protected static Logger logger = Logger.getLogger(StatsManager.class);

    protected static Hashtable stats = new Hashtable();

    protected static Stats root = new SimpleStats(Stats.ROOT_STATS);

    protected static Stack statsStack = new TrimmableStack(10,20);

    protected static Stats empty = createStats(null);

    public static void pushNewStats(String name)
    {
        if (exists(name)) {
            removeStats(name);
        }

        statsStack.push(getStats(name));
    }

    public static void pushStats(String name)
    {
        statsStack.push(getStats(name));
    }

    public static void popStats()
    {
        if (! statsStack.empty()) {
            statsStack.pop();
        }
    }

    public static Stats peekStats()
    {
        if (! statsStack.empty()) {
            return (Stats) statsStack.peek();
        } else {
            return empty;
        }
    }
    
    public static boolean exists(String name)
    {
        return stats.containsKey(name);
    }

    protected static Stats createStats(String name)
    {
        return new StatsWrapper(root,new SimpleStats(name));
    }

    public static Stats getRootStats()
    {
        return root;
    }

    public static Stats getStats(String name)
    {
        if (! exists(name)) {
            stats.put(name,createStats(name));
        }

        return (Stats) stats.get(name);
    }

    public static void removeStats(String name)
    {
        stats.remove(name);
    }
}
