package edu.buffalo.nsf.hippo.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.EnvironmentImpl;
import edu.buffalo.nsf.hippo.XMLConfiguration;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;

public final class StdinClient
{
    private static Configuration config;
    private static DataSource    source;
    private static Map           schema;
    private static Logger        logger;

    public static String  DEFAULT_CONFIG_FILE   = "config.xml";
    public static String  DEFAULT_TIME_DIAG_MSG = "false";

    /* keys for params */
    private static String CONFIG_FILE   = "config-file";
    private static String TIME_DIAG_MSG = "time-diag-msg";

    public static Map parseParams(String[] args)
    {
        Map params = Util.createMap();
        
        params.put(CONFIG_FILE,DEFAULT_CONFIG_FILE);
        params.put(TIME_DIAG_MSG,DEFAULT_TIME_DIAG_MSG);

        int i = 0;

        while (i < args.length) {
            if (args[i].equals("-c")) {
                if (i+1 < args.length) {
                    params.put(CONFIG_FILE,args[++i]);
                } else {
                    logger.warn("the parameter -c should be followed by " + 
                                "a full path to a config file \n");
                }
            } else if (args[i].equals("-td")) {
                params.put(TIME_DIAG_MSG,"true");
            } else {
                logger.warn("Unrecognized option " + args[i] + "... skiping.\n");
            };
            i++;
        }

        return params;
    }

    public static void main(String[] args) throws Throwable
    {
        try {
            Util.setUpLogger();
            
            logger = Logger.getLogger(Test.class);

            Map params = parseParams(args);

            String configFile = (String) params.get(CONFIG_FILE);

            boolean timeDiag = params.get(TIME_DIAG_MSG).equals("true");

            Environment   env    = new EnvironmentImpl();
            
            Configuration config = new XMLConfiguration(configFile);

            Engine        e      = env.getEngine(config);

            String dbName = config.getDBName();

            while ( true ) {
                System.out.print(dbName + "=# ");

                StringBuffer buf = new StringBuffer();
                int          ch;
                boolean      eof = false;

                do {
                    ch = System.in.read();
                    
                    if (ch == -1) {
                        logger.info("End of input received.");
                        System.out.println();
                        eof = true;
                        break;
                    }

                    buf.append((char) ch);
                    
                } while (ch != ';');

                if (eof) {
                    break;
                }

                String query = buf.toString().trim();

                logger.info("The query: " + query);
                
                Date start = new Date();

                try {
                    TupleStream ts = e.getConsistentAnswer(query);
                    
                    System.out.print(FormatUtil.txtFormat(ts));
                    logger.info(ts);

                    Date stop = new Date();

                    Date rt = new Date(stop.getTime() - start.getTime());

                    DateFormat f = new SimpleDateFormat("m:ss.SSS");
                    
                    if (timeDiag) {
                        logger.warn("Time elapsed: " + f.format(rt) +"\n");
                    }
                } catch (Throwable exc) {
                    exc.printStackTrace();
                    logger.error(exc);
                }
            }
            
            env.dispose(e);
            env.shutdown();

            //logger.info(StatsManager.getRootStats());

        } catch (Throwable t) {
            logger.fatal("Exception thrown.",t);
            throw t;
        }

    }
    

}
