package edu.buffalo.nsf.hippo.util;

import java.util.Date;
import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.ConfigConfiguration;
import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.EnvironmentImpl;
import edu.buffalo.nsf.hippo.XMLConfiguration;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.config.Config;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;

public final class Test
{
    private static Configuration config;
    private static DataSource    source;
    private static Map           schema;
    private static Logger        logger;

    public static void main(String[] args) throws Throwable
    {
        Util.setUpLogger();
        
        logger = Logger.getLogger(Test.class);
        
        String configFile = "config/hippo.xml";
        
        Environment   env    = new EnvironmentImpl();
        
        Config c = XMLConfiguration.readConfig(configFile);

        String dbName = args[0];

        c.getDbDescription().getConnectionParams().setDbName(dbName);

        Configuration config = new ConfigConfiguration(c);
        
        Date start = new Date();
        
        DataSource s = env.getDataSource(config);

        Hypergraph h = s.getHypergraph();
        
        Date stop = new Date();
        
        Date rt = new Date(stop.getTime() - start.getTime());
        
        //DateFormat f = new SimpleDateFormat("m:ss.SSS");

        //System.out.print(f.format(rt));
        System.out.print(rt.getTime() / 1000.0);
    }
}
