package edu.buffalo.nsf.hippo.util;

import java.io.IOException;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.commons.collections.LRUMap;
import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.varia.LevelRangeFilter;
// import edu.buffalo.nsf.hippo.data.config.Schema;
// import edu.buffalo.nsf.hippo.data.config.Relation;
// import edu.buffalo.nsf.hippo.data.config.Configuration;
// import edu.buffalo.nsf.hippo.data.config.DbDescription;


/**
 *  This class is a container of miscellaneous functions 
 *  often used in other parts of application.
 */
public final class Util
{
    private static Logger logger;// = Logger.getLogger(Util.class);
    private static boolean isLoggerInitialized = false;
    
    public static void setUpLogger()
    {
        setUpLogger(Level.DEBUG);
    }

    public static void setUpLogger(Level l)
    {        
        if (isLoggerInitialized) {
            return ;
        }
        try {
            //Logger.getRootLogger().addAppender(new LF5Appender());

            Logger.getRootLogger().setLevel(l);

            Layout layout = new PatternLayout("%p [(%d)%c{1}(%L) %M] - %m \n");

            Logger.getRootLogger().addAppender(new FileAppender(layout,"hippo.log",true));


            //Layout consLayout = new SimpleLayout();
            Layout consLayout = new PatternLayout("%m \n");
            LevelRangeFilter f = new LevelRangeFilter();
            f.setLevelMin(Level.WARN);
            f.setAcceptOnMatch(true);
            
            Appender consApp = new ConsoleAppender(consLayout,ConsoleAppender.SYSTEM_ERR);

            consApp.addFilter(f);

            Logger.getRootLogger().addAppender(consApp);

            logger = Logger.getLogger(Util.class);
            logger.info("Logger initialized.");
            isLoggerInitialized = true;
        } catch (IOException exc) {            
            try {
            System.err.println(exc.getMessage());
            logger.error("Problem with log file.", exc);
            } catch(Throwable t) {
                //ignoring
            }
        }
    }

    public static int getTupleCount(ResultSet rs)
    {
        return -1;
    }

    public static Map EMPTY_MAP = Collections.unmodifiableMap(createMap(0));

    public static List toList(Collection c)
    {
        if (c instanceof List) {
            return (List) c;
        } else {
            return createList(c);
        }
    }

    public static Set toSet(Collection c) 
    {
        if (c instanceof Set) {
            return (Set) c;
        } else {
            return createSet(c);
        }
    }

    public static List createList()
    {
        return new ArrayList();
    }

    public static List createList(Collection c)
    {
        return new ArrayList(c);
    }

    public static List createList(int initialSize)
    {
        return new ArrayList(initialSize);
    }

    public static List union(List c1, List c2)
    {
        List result = createList(c1.size() + c2.size());

        result.addAll(c1);
        result.addAll(c2);

        return result;
    }

    public static Set union(Set s1, Set s2)
    {
        Set result = createSet(s1.size() + s2.size());

        result.addAll(s1);
        result.addAll(s2);

        return result;
    }

    public static Set cut(Set s1, Set s2)
    {
        Set result = createSet();
        
        result.addAll(s1);
        result.retainAll(s2);

        return result;
    }

    /**
     *  Creates map with a limitied capacity, and 
     *  elements being removed on the Last Recently Used basis.
     */
    public static Map createLRUMap(int capacityLimit)
    {
        return new LRUMap(capacityLimit);
    }

    public static MultiMap createMultiMap(int initialSize)
    {
        return new MultiMapImpl(initialSize);
    }

    public static Map createMap()
    {
        return new HashMap();
    }

    public static Map createMap(Map map)
    {
        return new HashMap(map);
    }

    public static Map createMap(int initialCapacity)
    {
        return new HashMap(initialCapacity);
    }

    public static Set createSet()
    {
        return new HashSet();
    }

    public static Set createSet(Collection c)
    {
        return new HashSet(c);
    }

    public static Set createSet(int initialCapacity)
    {
        return new HashSet(initialCapacity);
    }
}
