package edu.buffalo.nsf.hippo;

import java.util.Map;

import edu.buffalo.nsf.hippo.data.config.IntegrityConstraints;
import edu.buffalo.nsf.hippo.data.config.Relation;


/**
 *  Configuration object. 
A change here and a modyfication there
 */
public interface Configuration
{

    public String  getDataSourceName();
    
    public boolean isDataSourceCached();

    public int     getDataSourceCacheSize();

    /**
     *  Returns map, which for a given relation name string returns 
     *  {@link Relation} object.
     */
    public Map getSchema();

    public String getDBName();

    public String getDBConnectURI();

    public String getDBUser();    

    public String getDBPassword();
    
    public String getDBDriverName();

    public IntegrityConstraints getIntegrityConstraints();

    public String getEngineName();

    public String getProverFactoryName();
    
    public Map    getResultInterpretation();

    public String getCoreSuffix();

    public String getTranslatorName();

    public String getCoreOperatorName();

    public String getShellOperatorName();
    
    public String getEnvelopeOperatorName();
}
