package edu.buffalo.nsf.hippo;

import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.parser.ParseException;

/**
 *  Main functionality of the package.
 *  This interfice specifies class of bojects responsible for
 *  processing simplified SQL queries and returning set of tuples (
 *  @see #getConsistentAnswer(String)).
 *  The method @see shutdown() should be called when the user is 
 *  not going to use this object any more. This allows to release 
 *  any resources used by the instance.
 */
public interface Engine extends Configurable
{
    /**
     *  Returns.hippo answer to a given query.
     *  @throws ParseException - in case the give query doesn't comply with the 
     *  simplified SQL grammar.
     */
    public TupleStream getConsistentAnswer(String sqlQuery) throws ParseException;
}
