package edu.buffalo.nsf.hippo;


/**
 *  A special Exception for unusual occasions.
 */
public class InternalProblem extends Error
{
    private static final long serialVersionUID = -271166331503765051L;
	protected Throwable t;
    
    /**
     *   Basic constructor.
     */
    public InternalProblem(String msg, Throwable t) 
    {
        super(msg);
        this.t = t;
    }

    public InternalProblem(String msg)
    {
        super(msg);
    }

    public InternalProblem(Throwable t)
    {
        this(t.getMessage(),t);
    }

    public String getMessage()
    {
        if (t == null) {
            return super.getMessage();
        }  else {
            return super.getMessage() + "[nested exception:" + t.getClass().getName() + " -- " + 
                "nested message: " + t.getMessage() + "]";
        }
    }
}
