package edu.buffalo.nsf.hippo;

import java.io.File;
import java.io.FileNotFoundException;

import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.config.Config;
import edu.buffalo.nsf.hippo.data.config.ObjectFactory;


/**
 *  Basic implementation based on XML configuration file.
 */
public class XMLConfiguration extends ConfigConfiguration
{
    protected static Logger logger = Logger.getLogger(XMLConfiguration.class);


    protected static ObjectFactory jc = new ObjectFactory();

    public static Config readConfig(String configFileName)
        throws FileNotFoundException, JAXBException
    {
        logger.debug("Reading configuration.");
        return readConfig(new File (configFileName));
    }
    
    public static Config readConfig(File configFile) throws JAXBException
    {
        Unmarshaller un = jc.createUnmarshaller();
        
        return (Config) un.unmarshal(configFile);
    	
    }

    public XMLConfiguration(String configFile)
        throws FileNotFoundException, JAXBException
    {
        super(readConfig(configFile));
    }
    
    public XMLConfiguration(File configFile) throws JAXBException 
    {
    	super(readConfig(configFile));
    }
}
