package edu.buffalo.nsf.hippo.data;

import edu.buffalo.nsf.hippo.data.graph.Vertex;

/**
 *  Source of data, on which engine will base its work.
 */
public class CachedDataSource extends DataSourceWrapper
{ 
    protected DataSourceCache cache;

    public CachedDataSource(DataSource source, DataSourceCache cache)
    {
        super(source);
        
        this.cache = cache;
    }

    public boolean checkVertex(Vertex v)
    {
        if (! cache.check(v)) {
            cache.store(v,super.checkVertex(v));
        }

        return cache.read(v);
    }
}
