package edu.buffalo.nsf.hippo.data;

import edu.buffalo.nsf.hippo.Configurable;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;

/**
 *  Source of data, on which engine will base its work.
 */
public interface DataSource extends Configurable
{
    /**
     *  Returns upper estimation of a.hippo query answer.
     */
    public TupleStream executeQuery(Query query);
    
    /**
     *  Returns hypergraph object.
     */
    public Hypergraph getHypergraph();

    /**
     *  Check whether the relation of a given name contains the given tuple.
     */
    public boolean checkVertex(Vertex v);
}
