package edu.buffalo.nsf.hippo.data;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;
import edu.buffalo.nsf.hippo.data.graph.Vertex;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;

/**
 *  Source of data, on which engine will base its work.
 */
public class DataSourceWrapper implements DataSource
{ 
    protected DataSource source;

    public DataSourceWrapper(DataSource source)
    {
        this.source = source;
    }

    public DataSource getWrappedDataSource()
    {
        return source;
    }

    public void init(Configuration config)
    {
        source.init(config);
    }

    public void shutdown()
    {
        source.shutdown();
    }

    public TupleStream executeQuery(Query query)
    {
        return source.executeQuery(query);
    }

    public Hypergraph getHypergraph ()
    {
        return source.getHypergraph();
    }

    public boolean checkVertex(Vertex v)
    {
        return source.checkVertex(v);
    }
}
