package edu.buffalo.nsf.hippo.data.formula;

import org.apache.log4j.Logger;

public abstract class Comparator
{
    protected static Logger logger = Logger.getLogger(Comparator.class);

    public abstract boolean compare   (Comparable o1, Comparable o2);

    public static final Comparator NEQ = 
        new Comparator() {
            public String toString()
            {
                return "<>";
            }
            
            public boolean compare(Comparable o1, Comparable o2)
            {
                return ! o1.equals(o2);
            }
        };

    public static final Comparator EQ = 
        new Comparator() {
            public String toString()
            {
                return "=";
            }
            
            public boolean compare(Comparable o1, Comparable o2)
            {
                return o1.equals(o2);
            }
        };

    public static final Comparator LE = 
        new Comparator() {
            public String toString()
            {
                return "<";
            }
            
            public boolean compare(Comparable o1, Comparable o2)
            {
                return o1.compareTo(o2) < 0;
            }
        };

    public static final Comparator GE = 
        new Comparator() {
            public String toString()
            {
                return ">";
            }
            
            public boolean compare(Comparable o1, Comparable o2)
            {
                return o1.compareTo(o2) > 0;
            }
        };

    public static final Comparator IS = 
        new Comparator() {
            public String toString()
            {
                return "==";
            }
            
            public boolean compare(Comparable o1, Comparable o2)
            {
                return o1 == o2;
            }
        };
}
