package edu.buffalo.nsf.hippo.data.formula;

import java.util.Map;

public class Constant implements Value
{
    public static final Constant NULL = new Constant(null);

    protected Object value;

    protected  Constant(Object value)
    {
        this.value = value;
    }

    public static Constant create(Object c)
    {
        if (c == null) {
            return NULL;
        } else {
            return new Constant(c);
        }
    }

    public Object getValue()
    {
        return value;
    }

    public boolean isGround()
    {
        return true;
    }

    public Value substitute(Map substitution)
    {
        return this;
    }

    public String toString()
    {
        return String.valueOf(value);
    }
}
