package edu.buffalo.nsf.hippo.data.formula;

import java.util.List;
import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;


public class Disjunction extends Formula
{
    protected List l;

    public static Formula create(Formula expr)
    {
        List l = Util.createList(1);

        l.add(expr);

        return create(l);
    }

    public static Formula create(Formula expr1, Formula expr2)
    {
        List l = Util.createList(2);
      
        l.add(expr1);
        l.add(expr2);

        return create(l);
    }

    public static Formula create(List l)
    {
        List l2 = Util.createList(l.size());

        for (int i = 0; i < l.size(); i++) {
            Formula f = (Formula) l.get(i);

            if (f == null) {
                throw new IllegalArgumentException("Null argument.");
            }

            if (f == TRUE) {
                return TRUE;
            }

            if (f == FALSE) {
                continue;
            }

            l2.add(f);
        }

        if (l2.isEmpty()) {
            return FALSE;
        }

        return new Disjunction(l2);
    }

    protected Disjunction(List l)
    {
        this.l = l;
    }
   
    public Formula substitute(Map substitution)
    {
        List tmp = Util.createList();
        
        for (int i = 0; i < l.size(); i++) {
            Formula f = (Formula) l.get(i);
            Formula g = f.substitute(substitution);
            
            tmp.add(g);
        }
      
        return Disjunction.create(tmp);
    }

    protected Formula pushDownNegations(boolean negationCarry)
    {
        List tmp = Util.createList();

        for (int i = 0; i < l.size(); i++) {
            tmp.add(((Formula) l.get(i)).pushDownNegations(negationCarry));
        }

        if (negationCarry) {
            return Conjunction.create(tmp);
        } else {
            return Disjunction.create(tmp);
        }
    }


    //SYSTEM WARNING:USER VERY TIRED, PLEASE DOUBLE CHECK BEFORE RUNNING
    protected Formula pushDownDisjunctions()
    {
        //Before finding the conjunction to be lifted we will try to normalize it,
        //so we have no more that one conjunction.
        normalize();
        // This may raise time complexity to n^2.
      
        //First, we will try to push recursively disjunctions.
        for (int i = 0; i < l.size(); i++) {
            ((Formula) l.get(i)).pushDownDisjunctions();
        }
      
        //Now, we will try to find some conjunction to lift it up.
        Conjunction conj = null;

        for (int i = 0; i < l.size(); i++) {
            if (l.get(i) instanceof Conjunction) {
                conj = (Conjunction) l.remove(i);
                break;
            }
        }

        if (conj == null) {
            //If we haven't found any conjunction it means that we have only
            //disjunction of literals, so we return this instance.
            return this;
        } else {
            //So we have a conjunction. 
            //Let's take the list of components of this conjunction.
            List c = conj.l;

            List result = Util.createList();

            //Now we will "multiply" elements of this conjunction with the rest.

            for (int i = 0; i < c.size(); i++) {
                Formula f = (Formula) c.get(i);

                List tmp = Util.createList();

                tmp.addAll(l);
                tmp.add(f);

                //And once again we push down disjunctions.
                result.add((Disjunction.create(tmp)).pushDownDisjunctions());
            }

            return Conjunction.create(result);
        }
    }

    public void normalize()
    {      
        int i = 0;
        while (i < l.size()) {
            Formula f = (Formula) l.get(i);

            f.normalize();

            if (f instanceof Disjunction) {
                Disjunction d = (Disjunction) l.remove(i);
                l.addAll(d.l);
            } else {	    
                i++;
            }
        }
    }

    public String toString()
    {
        if (l.isEmpty()) {
            return "FALSE";
        }

        String result = new String();

        for (int i = 0; i < l.size(); i++) {

            result += "(" + l.get(i).toString() + ")";

            if (i < l.size() - 1) {
                result += " OR ";
            }
        }

        return result;
    }

    public List getDisjuncts()
    {
        return l;
    }
}
