 package edu.buffalo.nsf.hippo.data.formula;

import java.util.Map;

public class Variable implements Value
{
    protected String name;

    public Variable(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }

    public Value substitute(Map s)
    {
        if (s.containsKey(name)) {
            return (Value) s.get(name);
        } else {
            return this;
        }
    }

    public boolean isGround()
    {
        return false;
    }

    public String toString()
    {
        return name;
    }
}
