package edu.buffalo.nsf.hippo.data.graph;

import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.config.Bind;
import edu.buffalo.nsf.hippo.data.config.DenialConstraint;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.util.HashUtil;
import edu.buffalo.nsf.hippo.util.Util;

public class Edge
{
    private static Logger logger = Logger.getLogger(Edge.class);
    
    protected Set vertices;
    protected int hashCode;

    protected Edge(Collection vertices)
    {
        this.vertices = Util.toSet(vertices);
        this.hashCode = HashUtil.hashCode(this);

        //logger.debug("Created : " + this + " with hashcode = " + hashCode);
    }

    public static Edge create(DenialConstraint dc, Map schema, Tuple t)
    {
        Set       vertices = Util.createSet();
        int       index = 0;

        for (int i = 0; i < dc.getBindingLength(); i++) {
            Bind     b     = dc.getBinding(i);
            String   name  = b.getRelationName();
            Relation r     = (Relation) schema.get(name);
            int      count = r.getFieldLength();
            Tuple    sub   = Tuple.extract(t,index,count);
            Vertex   v     = Vertex.create(name,sub);

            //logger.debug("adding vertex: " + v);
            vertices.add(v);

            index += count;            
        }

        return new Edge(vertices);
    }

    /**
     * Returns list of all neigbors of v 
     * in the scope of this edge.
     */
    public Set getNeighbors(Vertex v)
    {
        Set neighbors = Util.createSet(vertices);
        
        neighbors.remove(v);

        return neighbors;
    }

    public Set getVertices()
    {
        return vertices;
    }

    public int hashCode()
    {
        return hashCode;
    }

    public static boolean equal(Edge e1, Edge e2)
    {
        //        logger.debug("Comparing " + e1 + " with " + e2 );

        boolean result = e1 == e2 || e1.getVertices().equals(e2.getVertices());

        //logger.debug("Comparing " + e1 + " with " + e2 + " = " + result);

        return result;
    }

    public boolean equals(Object o)
    {
        if (o instanceof Edge) {
            return equal(this,(Edge) o);
        } else {
            return false;
        }
    }   
    
    public String toString()
    {
        return "E:" + vertices;
    }
}
