package edu.buffalo.nsf.hippo.data.graph;

import java.util.Iterator;
import java.util.Set;

import edu.buffalo.nsf.hippo.data.DataSource;


/**
 *  Addition of support of the contains operation based on a given DataSource.
 */
public class ExternalHypergraphExtention extends HypergraphWrapper
{
    protected DataSource source;

    public ExternalHypergraphExtention(Hypergraph g, DataSource source)
    {
        super(g);
        this.source = source;
    }

    public boolean contains(Vertex v)
    {
        return source.checkVertex(v);
    }

    public boolean contains(Set vertices)
    {
        Iterator iter   = vertices.iterator();
        boolean  result = true;
        
        
        while (result && iter.hasNext()) {
            Vertex v = (Vertex) iter.next();
            
            result = contains(v);
        }

        return result;
    }
}

