package edu.buffalo.nsf.hippo.data.graph;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

import org.apache.commons.collections.MultiMap;
import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.util.Util;


/**
 *  Implementation of Hypergraph based on internal memory. 
 *  This class does not supports the contains operation.
 *
 */
public class InternalHypergraphImpl extends Hypergraph
{
    protected static Logger logger = Logger.getLogger(InternalHypergraphImpl.class);

    protected MultiMap map;

    public InternalHypergraphImpl(Set edges)
    {
        //logger.debug("Creating hypergraph with: " + edges);
        
        map = Util.createMultiMap(edges.size());

        Iterator iter = edges.iterator();

        while (iter.hasNext()) {            
            Edge     e        = (Edge) iter.next();
            Iterator vertices = e.getVertices().iterator();

            while (vertices.hasNext()) {
                Vertex v = (Vertex) vertices.next();
                
                map.put(v,e);
            }
        }

        //logger.debug("Created: " + map);
    }

    public boolean isConflicting(Vertex v)
    {
        return map.containsKey(v);
    }

    public Set   incident(Vertex v)
    {
        //logger.debug("Looking for incident edges for " + v);

        Set inc = (Set) map.get(v);

        //logger.debug("Map returns " + inc);

        if (inc == null) {
            return Collections.EMPTY_SET;
        } else {
            return inc;
        }
    }
    
    public boolean  isIndependent(Set vertices)
    {

        Set edges = Util.createSet();
        Iterator iter = vertices.iterator();

        while (iter.hasNext()) {
            Vertex v = (Vertex) iter.next();

            edges.addAll((Set) incident(v));
        }

        //logger.debug("Checking edges set: " + edges);

        iter = edges.iterator();

        while (iter.hasNext()) {
            Edge e = (Edge) iter.next();

            if (vertices.containsAll(e.getVertices())) {
                return false;
            }
        }

        return true;
    }

    public boolean contains(Vertex v)
    {
        throw new UnsupportedOperationException();
    }
}

