package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;

public class FromSubquery extends FromExpr
{
    protected Query  subquery;
    protected String bindName;

    public FromSubquery(Query subquery, String bindName) 
    {
        this.subquery = subquery;
        this.bindName = bindName;
    }

    public Query getSubquery()
    {
        return subquery;
    }

    public String getBindingName()
    {
        return bindName;
    }

    public String getRefName()
    {
        return bindName;
    }

    public int getExprType()
    {
        return subquery.getExprType();
    }

    public String toSQLString(Map params)
    {
        return "(" + subquery.toSQLString(params) + ") AS " + bindName;
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
