package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import org.apache.log4j.Logger;

public class Select extends Query
{
    protected static Logger logger = Logger.getLogger(Select.class);

    protected SelectList       selectList;
    protected FromList         fromList;
    protected WhereCondition   whereCondition;
    protected GroupByList      groupByList;

    protected int              exprType;

    public Select(SelectList     selectList, 
                  FromList       fromList,
                  WhereCondition whereCondition,
                  GroupByList    groupByList)
    {
        this.selectList     = selectList;
        this.fromList       = fromList;
        this.whereCondition = whereCondition;
        this.groupByList    = groupByList;

        exprType = selectList.getExprType() | fromList.getExprType();
        
        if (whereCondition != null) {
            exprType |= Query.SELECTION;
        }
    }
        
    public int getExprType()
    {
        return exprType;
    }

    public SelectList getSelectList()
    {
        return selectList;
    }

    public FromList getFromList()
    {
        return fromList;
    }

    public WhereCondition getWhereCondition()
    {
        return whereCondition;
    }

    public GroupByList getGroupByList()
    {
        return groupByList;
    }
        
    public String toSQLString(Map params)
    {
        String result = "SELECT ";
            
        result += selectList.toSQLString(params);

        result += " FROM ";
            
        result += fromList.toSQLString(params);

        if (whereCondition != null) {
            result += " WHERE ";                
            result += whereCondition.toSQLString(params);
        }

        if (groupByList != null) {
            result += " GROUP BY ";
            result += groupByList.toSQLString(params);
        }
            
        return result;
    }
}
