package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;

public class SelectAggregate extends SelectExpr
{
    protected String      aggrName;
    protected SelectField aggrField;

    public SelectAggregate(String aggrName, SelectField aggrField)
    {
        this.aggrName = aggrName;
        this.aggrField = aggrField;
    }

    public String getAggregateName()
    {
        return aggrName;
    }

    public SelectField getAggregatedField()
    {
        return aggrField;
    }

    public int getExprType()
    {
        return Query.AGGREGATION;
    }

    public String toSQLString(Map params)
    {
        return aggrName + "(" + aggrField.toSQLString(params) + ")";
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
