package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;


public class Union extends Query
{
    protected Query expr1;
    protected Query expr2;
        
    protected int exprType;

    public Union(Query expr1, Query expr2)
    {
        this.expr1 = expr1;
        this.expr2 = expr2;

        exprType = Query.UNION |
            expr1.getExprType() |
            expr2.getExprType();
    }

    public int getExprType()
    {
        return exprType;
    }

    public Query getExpr1()
    {
        return expr1;
    }

    public Query getExpr2()
    {
        return expr2;
    }

    public String toSQLString(Map params)
    {
        return  '(' + expr1.toSQLString(params) + ')' +
            " UNION " +
            '(' + expr2.toSQLString(params) + ')';
    }
}
