package edu.buffalo.nsf.hippo.data.query;

import java.util.Map;

import edu.buffalo.nsf.hippo.util.Util;

public class WhereConjunction extends WhereCondition
{
    protected WhereCondition cond1;
    protected WhereCondition cond2;

    public WhereConjunction(WhereCondition cond1, WhereCondition cond2)
    {
        this.cond1 = cond1;
        this.cond2 = cond2;
    }

    public WhereCondition getCondition1()
    {
        return cond1;
    }

    public WhereCondition getCondition2()
    {
        return cond2;
    }


    public String toSQLString(Map params)
    {
        return "(" + cond1.toSQLString(params) + ") AND (" + cond2.toSQLString(params) + ")";
    }

    public String toString()
    {
        return toSQLString(Util.EMPTY_MAP);
    }
}
