package edu.buffalo.nsf.hippo.data.query.traverse;

import java.util.EmptyStackException;
import java.util.List;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.util.Util;


public class BindingStack
{
    protected static Logger logger = Logger.getLogger(BindingStack.class);

    protected class Binding {
        public Relation  rel;
        public String    bind;
        public int       offset;
        
        public Binding(Relation rel, String bind, int offset)
        {
            this.rel    = rel;
            this.bind   = bind;
            this.offset = offset;
        }
    }

    protected List stack;

    public BindingStack()
    {
        this.stack = Util.createList();
    }

    public void clear()
    {
        stack.clear();
    }

    public void push(Relation rel, String bind, int offset)
    {
        stack.add(new Binding(rel,bind,offset));
    }
    

    public void pop()
    {
        if (stack.isEmpty()) {
            throw new EmptyStackException();
        }
        
       stack.remove(stack.size() - 1);
    }

    public void pop(int i)
    {
        while (i-- > 0) {
            pop();
        }
    }

    /**
     *  Reverses <code>get(int i)</code> with respect to length.
     */
    protected Binding peek(int i)
    {
        return (Binding) stack.get(stack.size() - (i+1));
    }

    public int find(String bindName, String fieldName)
    {        
        for (int i = 0; i < stack.size(); i ++) {
            if (peek(i).bind.equals(bindName)) {
                for (int j = 0; j < peek(i).rel.getFieldLength(); j++){
                    if (peek(i).rel.getField(j).getName().equals(fieldName)) {
                        return peek(i).offset + j;
                    }
                }

                throw new IllegalArgumentException(
                  "Field " + fieldName + " not found in binding variable " + bindName + "."
                );
            }
        }

        throw new IllegalArgumentException("Variable binding " + bindName + " not found.");
    }

    public int find(String fieldName)
    {
        for (int i = 0; i < stack.size(); i ++) {
            for (int j = 0; j < peek(i).rel.getFieldLength(); j++){
                if (peek(i).rel.getField(j).getName().equals(fieldName)) {
                    return peek(i).offset + j;
                }
            }

        }

        throw new IllegalArgumentException(
              "Field " + fieldName + " not found."
        );
    }
}
