package edu.buffalo.nsf.hippo.data.query.traverse;


import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.FromSubquery;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Intersection;
import edu.buffalo.nsf.hippo.data.query.OuterJoin;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.Select;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.Union;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.util.Util;

public class ExtendedFOperator implements QueryTransformer
{
    protected Logger logger = Logger.getLogger(ExtendedFOperator.class);

    protected QueryTransformer f;
    protected QueryTransformer u;
    protected Environment      env;
    protected Map              schema;
    protected String           coreSuffix;

    protected class RI {
        public String rel;
        public int      attr;

        public  RI(String rel, int attr)
        {
            this.rel = rel;
            this.attr = attr;
        }

        public boolean equals(Object o) {
            return equal(this, (RI) o);
        }

        public boolean equal(RI o1, RI o2)
        {
            return o1.rel.equals(o2.rel) && o1.attr == o2.attr;
        }

        public int hashCode()
        {
            return 0;
        }

        public String toString()
        {
            return rel+"_"+attr;
        }
    }

    public ExtendedFOperator(Environment env)
    {
        this.env = env;
        this.u = new UniformTransformer(env);
    }

    public void init(Configuration config)
    {
        this.schema = config.getSchema();
        this.coreSuffix = config.getCoreSuffix();
        this.f = env.getShellOperator(config);
        this.u.init(config);
    }

    public void shutdown()
    {
        u.shutdown();
        env.dispose(f);        
    }

    protected Relation getRelation(String relName)
    {
        if (relName.endsWith(coreSuffix)) {
            relName = relName.substring(0,relName.length() - coreSuffix.length());
        }

        return (Relation) schema.get(relName);
    }

    public Query transform(Query q)
    {
        List skg = findSKG(q);
        logger.debug("This is skg:" + skg);        
        List stc = findSTC(q);
        logger.debug("This is stc:" + stc);


        RI[] ri = getGamma(skg,stc);
        Relation[] r = new Relation[ri.length];
        int[] offset = new int[ri.length];

        for (int i = 0; i < ri.length; i++) {
            r[i] = getRelation(ri[i].rel);
            offset[i] = ri[i].attr;
        }
        
        if (r.length > 0) {
            return new OuterJoin(u.transform(f.transform(q)),stc.size(),r,offset);
        } else {
            return f.transform(q);
        }
    }


    protected RI[] getGamma(List skg, List stc)
    {
        List gamma = Util.createList();

        List c = Util.createList();
        for (int i = 0; i < skg.size(); i++) {
            ((Set) stc.get(i)).removeAll((Set) skg.get(i));
            c.add(stc.get(i));
        }
        
        for (int i = 0; i < c.size(); i++) {
            Iterator s = ((Set) c.get(i)).iterator();

            while (s.hasNext()) {
                RI o = (RI) s.next();

                if (o.attr == 0) {
                    gamma.add(new RI(o.rel,i));
                }
            }
        }

        return (RI[]) gamma.toArray(new RI[0]);
    }

    protected List findSKG(Query q)
    {
        if (q instanceof Select ) {
            Select s = (Select) q;
            
            return findSKGSelect(s.getSelectList(), 
                                   s.getFromList(), 
                                   s.getWhereCondition(),
                                   s.getGroupByList());
        } else if (q instanceof Difference) {
            Difference d = (Difference) q;
            
            return findSKGDifference(d.getExpr1(),d.getExpr2());
        } else if (q instanceof Intersection) {
            Intersection i = (Intersection) q;
            
            return findSKGIntersection(i.getExpr1(), i.getExpr1());
        } else if (q instanceof Union) {
            Union u = (Union) q;
            
            return findSKGUnion(u.getExpr1(),u.getExpr2());
        } else {
            throw new IllegalArgumentException("Unknown Query subclass.");
        }
    }

    protected List findSKG(FromExpr fromExpr)
    {
        if (fromExpr instanceof FromRelation) {
            FromRelation r = (FromRelation) fromExpr;

            return findSKGFromRelation(r.getRelationName(),
                                         r.getBindingName());
        } else if (fromExpr instanceof FromSubquery) {
            FromSubquery s = (FromSubquery) fromExpr;

            return findSKGFromSubquery(s.getSubquery(),
                                         s.getBindingName());
        } else {
            throw new IllegalArgumentException("Unknown FromExpr subclass.");
        }
    }

    protected List findSKGSelect(SelectList selectList,
                                 FromList fromList,
                                 WhereCondition whereCondition,
                                 GroupByList groupByList)
    {
        if (groupByList != null) {
            throw new IllegalArgumentException(
              "This translator can be used only for SJUID queires."
            );
        }

        return findSKGFromList(fromList.getFromExpr());
    }

    protected List findSKGFromList(FromExpr[] fromExpr)
    {
        List res = Util.createList();
        
        for (int i = 0; i < fromExpr.length; i++) {
            res.addAll(findSKG(fromExpr[i]));
        }
        
        return res;
    }

    protected List findSKGFromRelation(String relName, String bindName)
    {
        Relation r   = (Relation) getRelation(relName);
        List     res = Util.createList();
        
        for (int i = 0; i < r.getFieldLength(); i++) {
            Set s = Util.createSet();
            
            s.add(new RI(relName,i));

            res.add(s);
        }

        return res;
    }

    protected List findSKGFromSubquery(Query q, String bindName)
    {
        return findSKG(q);
    }

    protected List findSKGDifference (Query expr1, Query expr2)
    {
        return findSKG(expr1);
    }

    protected List findSKGIntersection (Query expr1, Query expr2)
    {
        List skg1 = findSKG(expr1);
        List skg2 = findSKG(expr2);
        List skg = Util.createList();

        for (int i = 0; i < skg1.size(); i++) {
            skg.add(Util.union((Set) skg1.get(i), (Set) skg2.get(i)));
        }

        return skg;
    }

    protected List findSKGUnion (Query expr1, Query expr2)
    {
        List skg1 = findSKG(expr1);
        List skg2 = findSKG(expr2);
        List skg = Util.createList();

        for (int i = 0; i < skg1.size(); i++) {
            skg.add(Util.cut((Set) skg1.get(i), (Set) skg2.get(i)));
        }

        return skg;
    }

    public List findSTC(Query q)
    {
        if (q instanceof Select ) {
            Select s = (Select) q;
            
            return findSTCSelect(s.getSelectList(), 
                                   s.getFromList(), 
                                   s.getWhereCondition(),
                                   s.getGroupByList());
        } else if (q instanceof Difference) {
            Difference d = (Difference) q;
            
            return findSTCDifference(d.getExpr1(),d.getExpr2());
        } else if (q instanceof Intersection) {
            Intersection i = (Intersection) q;
            
            return findSTCIntersection(i.getExpr1(), i.getExpr1());
        } else if (q instanceof Union) {
            Union u = (Union) q;
            
            return findSTCUnion(u.getExpr1(),u.getExpr2());
        } else {
            throw new IllegalArgumentException("Unknown Query subclass.");
        }
    }

    protected List findSTC(FromExpr fromExpr)
    {
        if (fromExpr instanceof FromRelation) {
            FromRelation r = (FromRelation) fromExpr;

            return findSTCFromRelation(r.getRelationName(),
                                         r.getBindingName());
        } else if (fromExpr instanceof FromSubquery) {
            FromSubquery s = (FromSubquery) fromExpr;

            return findSTCFromSubquery(s.getSubquery(),
                                         s.getBindingName());
        } else {
            throw new IllegalArgumentException("Unknown FromExpr subclass.");
        }
    }

    protected List findSTCSelect(SelectList selectList,
                                 FromList fromList,
                                 WhereCondition whereCondition,
                                 GroupByList groupByList)
    {
        if (groupByList != null) {
            throw new IllegalArgumentException(
              "This translator can be used only for SJUID queires."
            );
        }

        return findSTCFromList(fromList.getFromExpr());
    }

    protected List findSTCFromList(FromExpr[] fromExpr)
    {
        List res = Util.createList();
        
        for (int i = 0; i < fromExpr.length; i++) {
            res.addAll(findSTC(fromExpr[i]));
        }
        
        return res;
    }

    protected List findSTCFromRelation(String relName, String bindName)
    {
        Relation r   = (Relation) getRelation(relName);
        List     res = Util.createList();
        
        for (int i = 0; i < r.getFieldLength(); i++) {
            Set s = Util.createSet();
            
            s.add(new RI(relName,i));

            res.add(s);
        }

        return res;
    }

    protected List findSTCFromSubquery(Query q, String bindName)
    {
        return findSTC(q);
    }

    protected List findSTCDifference (Query expr1, Query expr2)
    {
        List skg1 = findSTC(expr1);
        List skg2 = findSTC(expr2);
        List skg = Util.createList();

        for (int i = 0; i < skg1.size(); i++) {
            skg.add(Util.union((Set) skg1.get(i), (Set) skg2.get(i)));
        }

        return skg;
    }

    protected List findSTCIntersection (Query expr1, Query expr2)
    {
        List skg1 = findSTC(expr1);
        List skg2 = findSTC(expr2);
        List skg = Util.createList();

        for (int i = 0; i < skg1.size(); i++) {
            skg.add(Util.union((Set) skg1.get(i), (Set) skg2.get(i)));
        }

        return skg;
    }

    protected List findSTCUnion (Query expr1, Query expr2)
    {
        List skg1 = findSTC(expr1);
        List skg2 = findSTC(expr2);
        List skg = Util.createList();

        for (int i = 0; i < skg1.size(); i++) {
            skg.add(Util.union((Set) skg1.get(i), (Set) skg2.get(i)));
        }

        return skg;
    }

}
