package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.Query;

public class HybridFOperator extends PhonyTransformer
{

    protected QueryTransformer g;
    protected Environment      env;

    public HybridFOperator(Environment env)
    {
        this.env = env;
    }

    public void init(Configuration config)
    {
        this.g = env.getCoreOperator(config);
    }

    public void shutdown()
    {
        env.dispose(g);
    }

    protected Query transformDifference(Query expr1, Query expr2)
    {
        return new Difference(transform(expr1),g.transform(expr2));
    }
}
