package edu.buffalo.nsf.hippo.data.query.traverse;

import java.util.Map;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Constants;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromList;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.FromSubquery;
import edu.buffalo.nsf.hippo.data.query.GroupByList;
import edu.buffalo.nsf.hippo.data.query.Intersection;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.Select;
import edu.buffalo.nsf.hippo.data.query.SelectExpr;
import edu.buffalo.nsf.hippo.data.query.SelectField;
import edu.buffalo.nsf.hippo.data.query.SelectList;
import edu.buffalo.nsf.hippo.data.query.Signature;
import edu.buffalo.nsf.hippo.data.query.Union;
import edu.buffalo.nsf.hippo.data.query.WhereCondition;
import edu.buffalo.nsf.hippo.util.Util;

public class UniformTransformer extends PhonyTransformer implements Constants
{

    protected int varIndex;
    protected Map sigs;
    protected Map schema;
    protected String coreSuffix;

    public UniformTransformer(Environment env)
    {
        
    }

    public void init(Configuration config)
    {
        schema = config.getSchema();
        coreSuffix = config.getCoreSuffix();
    }

    public void shutdown()
    {
    }

    protected Relation getRelation(String relName)
    {
        if (relName.endsWith(coreSuffix)) {
            relName = relName.substring(0,relName.length() - coreSuffix.length());
        }

        return (Relation) schema.get(relName);
    }

    public Query transform(Query q)
    {
        varIndex = 0;
        sigs = Util.createMap();
        return super.transform(q);
    }

    protected Query transformSelect(SelectList selectList,
                                    FromList fromList,
                                    WhereCondition whereCondition,
                                    GroupByList groupByList)
    {
        if (groupByList != null) {
            throw new IllegalArgumentException(
              "This translator can be used only for SJUID queires."
            );
        }

        

        int _varIndex = varIndex;

        FromList f = transformFromList(fromList.getFromExpr());
        

        SelectExpr[] se = new SelectExpr[varIndex - _varIndex];

        varIndex = _varIndex;

        int k = 0;

        for (int i = 0; i < f.getFromExpr().length; i++) {
            FromExpr fe = f.getFromExpr()[i];

            if (fe instanceof FromRelation) {
                FromRelation fr  = (FromRelation) fe;                
                Relation     rel = getRelation(fr.getRelationName());
                    
                for (int j = 0; j < rel.getFieldLength(); j++) {
                    
                    se[k++] = new SelectField(fr.getRefName(),
                                              rel.getField(j).getName(),
                                              OJ_VAR_PREFIX + varIndex);
                    varIndex++;
                }
            } else {
                Signature sig = (Signature) sigs.get(fe);

                for (int j = 0; j < sig.getLength(); j++) {
                    
                    se[k++] = new SelectField(fe.getRefName(), 
                                              OJ_VAR_PREFIX + varIndex,
                                              OJ_VAR_PREFIX + varIndex);
                    
                    varIndex++;
                }
            }
        }

        return new Select(new SelectList(se),f,whereCondition, groupByList);
    }

    protected FromExpr transformFromRelation(String relName, String bindName)
    {
        FromRelation r = new FromRelation(relName,bindName);

        Relation rel = (Relation) getRelation(relName);

        varIndex += rel.getFieldLength();

        return r;
    }

    protected FromSubquery transformFromSubquery(Query q, String bindName)
    {
        int offset = varIndex;
        
        FromSubquery s = new FromSubquery(transform(q),bindName);

        Signature sig = new Signature(offset, varIndex - offset);

        return s;
    }

    protected Query transformDifference (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;

        Query q1 = transform(expr1);
        
        varIndex = _varIndex;
        
        Query q2 = transform(expr2);

        return new Difference(q1,q2);
    }

    protected Query transformIntersection (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;

        Query q1 = transform(expr1);
        
        varIndex = _varIndex;
        
        Query q2 = transform(expr2);

        return new Intersection(q1,q2);
    }

    protected Query transformUnion (Query expr1, Query expr2)
    {
        int _varIndex = varIndex;

        Query q1 = transform(expr1);
        
        varIndex = _varIndex;
        
        Query q2 = transform(expr2);

        return new Union(q1,q2);
    }
}
