package edu.buffalo.nsf.hippo.data.query.traverse;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.query.Difference;
import edu.buffalo.nsf.hippo.data.query.FromExpr;
import edu.buffalo.nsf.hippo.data.query.FromRelation;
import edu.buffalo.nsf.hippo.data.query.Query;

public class ViewBasedGOperator extends PhonyTransformer
{
    protected Environment      env;
    protected QueryTransformer f;

    protected String coreSuffix;

    public ViewBasedGOperator(Environment env)
    {
        this.env = env;
    }

    public void init(Configuration config)
    {
        this.f          = env.getShellOperator(config);
        this.coreSuffix = config.getCoreSuffix();
    }
    
    public void shutdown()
    {
        //env.dispose(f);
    }

    protected Query transformDifference(Query expr1, Query expr2)
    {
        return new Difference(transform(expr1),f.transform(expr2));
    }

    protected FromExpr transformFromRelation(String relName, String bindName)
    {
        if (bindName == null) {
            return new FromRelation(relName + coreSuffix,relName);
        } else {
            return new FromRelation(relName + coreSuffix,bindName);
        }
    }
}
