package edu.buffalo.nsf.hippo.data.tuple;


public class TrimmingTupleStream extends TupleStream
{
    protected TupleStream ts;
    protected int length;
    protected TupleMetaData metaData;

    public TrimmingTupleStream(TupleStream ts, int length)
    {
        this.ts = ts;
        this.length = length;
        this.metaData = TupleMetaData.getSubset(ts.getMetaData(),0,length);
    }

    public TupleMetaData getMetaData()
    {
        return metaData;
    }
   
    public boolean hasNext()
    {
        return ts.hasNext();
    }

    public Tuple getNext()
    {
        return Tuple.extract(ts.getNext(),0,length);
    }
}
