package edu.buffalo.nsf.hippo.data.tuple;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;

import org.apache.log4j.Logger;

public abstract class Tuple
{
    protected static Logger logger = Logger.getLogger(Tuple.class);

    protected boolean       wasNull = false;

    public abstract Object getObject (int fieldIndex);

    public abstract int getFieldCount();

    public boolean wasNull ()
    {
        return wasNull;
    }

    public boolean isNULL()
    {
        for (int i = 0; i < getFieldCount(); i++) {
            if (getObject(i) != null) {
                return false;
            }
        }

        return true;
    }

    public String getString (int fieldIndex)
    {
        return (String) getObject(fieldIndex);
    }

    public boolean   getBoolean   (int fieldIndex)
    {
        try {
            return ((Boolean) getObject(fieldIndex)).booleanValue();
        } catch (NullPointerException exc) {
            return false;
        }
    }

    public byte      getByte      (int fieldIndex)
    {
        try {
            return ((Number) getObject(fieldIndex)).byteValue();
        } catch (NullPointerException exc) {
            return 0;
        }
    }

    public short     getShort     (int fieldIndex)
    {
        try {
            return ((Number) getObject(fieldIndex)).shortValue();
        } catch (NullPointerException exc) {
            return 0;
        }
    }

    public int       getInt       (int fieldIndex)
    {
        try {
            return ((Number) getObject(fieldIndex)).intValue();
        } catch (NullPointerException exc) {
            return 0;
        }
    }

    public long      getLong      (int fieldIndex)
    {
        try {
            return ((Number) getObject(fieldIndex)).longValue();
        } catch (NullPointerException exc) {
            return 0;
        }
    }

    public float     getFloat     (int fieldIndex)
    {
        try {
            return ((Number) getObject(fieldIndex)).floatValue();
        } catch (NullPointerException exc) {
            return 0f;
        }
    }

    public double    getDouble    (int fieldIndex)
    {
        try {
            return ((Number) getObject(fieldIndex)).doubleValue();
        } catch (NullPointerException exc) {
            return 0.;
        }
    }

    public Date      getDate      (int fieldIndex)
    {
        return (Date) getObject(fieldIndex);
    }

    public Time      getTime      (int fieldIndex)
    {
        return (Time) getObject(fieldIndex);
    }
    
    public Timestamp getTimestamp (int fieldIndex)
    {
        return (Timestamp) getObject(fieldIndex);
    }


//     public int findField(String fieldName) 
//     {
//         return getMetaData().getFieldIndex(fieldName);
//     }
    

//     public String getString (String fieldName)
//     {
//         return getString(findField(fieldName));
//     }
    
//     public boolean   getBoolean   (String fieldName)
//     {
//         return getBoolean(findField(fieldName));
//     }

//     public byte      getByte      (String fieldName)
//     {
//         return getByte(findField(fieldName));
//     }

//     public short     getShort     (String fieldName)
//     {
//         return getShort(findField(fieldName));
//     }

//     public int       getInt       (String fieldName)
//     {
//         return getInt(findField(fieldName));
//     }

//     public long      getLong      (String fieldName)
//     {
//         return getLong(findField(fieldName));
//     }

//     public float     getFloat     (String fieldName)
//     {
//         return getFloat(findField(fieldName));
//     }

//     public double    getDouble    (String fieldName)
//     {
//         return getDouble(findField(fieldName));
//     }

//     public Date      getDate      (String fieldName)
//     {
//         return getDate(findField(fieldName));
//     }

//     public Time      getTime      (String fieldName)
//     {
//         return getTime(findField(fieldName));
//     }

//     public Timestamp getTimestamp (String fieldName)
//     {
//         return getTimestamp(findField(fieldName));
//     }

    public String toString()
    {
        StringBuffer result = new StringBuffer("T[");

        for(int i = 0; i < getFieldCount(); i++) {
            result.append(getObject(i)).append(',');
        }
        
        result.setCharAt(result.length() - 1,']');

        return result.toString();
    }

    public int hashCode()
    {
        int h = 0;

        for (int i = 0; i < getFieldCount(); i++) {
            h *= 32;
            if (getObject(i) != null) {
                h += getObject(i).hashCode();
            }
        }

        return h;
    }

    public boolean equals(Object o) 
    {        
        if (o instanceof Tuple) {
            return equal(this,(Tuple) o);
        } else {
            return false;
        }
    }

    protected static boolean equal(Tuple t1, Tuple t2)
    {
        if (t1 == t2) {
            //            logger.debug(t1+ " - the same pointer.");
            
            return true;
        }
        
        boolean result = t1.getFieldCount() == t2.getFieldCount();

        int     count  = t1.getFieldCount();

        for (int i = 0; result && i < count; i++) {
            Object o1 = t1.getObject(i);
            Object o2 = t2.getObject(i);

            result = o1 == o2 || (o1 != null && o2 != null && o1.equals(o2));
        }

        //        logger.debug(t1+ " "  + ((result) ? ("equals"):("doesn't equal")) + " " + t2);

        return result;
    }

    public static Tuple EMPTY_TUPLE = 
        new ArrayTuple(new Object[0]);

    

    public static Tuple create(Object o)
    {
        Object[] arr = new Object[1];
        arr[0] = o;

        return create(arr);
    }

    public static Tuple create(Object[] row)
    {
        return new ArrayTuple(row);
    }

    public static Tuple extract(Tuple tuple, int start, int count)
    {
        return new Subtuple(tuple,start,count);
    }

    public static Tuple concat(Tuple tuple1, Tuple tuple2)
    {
        return new ConcatTuple(tuple1,tuple2);
    }

    protected static class ArrayTuple extends Tuple
    {
        protected Object[] row;

        public ArrayTuple(Object[] row)
        {
            this.row      = row;
        }

        public int getFieldCount()
        {
            return row.length;
        }

        public Object getObject(int fieldIndex)
        {
            if (fieldIndex < 0 || fieldIndex > row.length - 1) {
                throw new IllegalArgumentException("Wrong field index.");
            }
        
            wasNull = row[fieldIndex] == null;

            return row[fieldIndex];
        }
    }

    protected static class Subtuple extends Tuple
    {
        protected Tuple         tuple;
        protected int           startField;
        protected int           fieldCount;

        protected Subtuple(Tuple tuple, int startField, int fieldCount)
        {
            this.startField = startField;
            this.fieldCount = fieldCount;

            this.tuple      = tuple;
        }

        public int getFieldCount()
        {
            return fieldCount;
        }

        public Object getObject(int fieldIndex)
        {
            Object result;

            if (fieldIndex < 0 || fieldIndex > fieldCount - 1) {
                throw new IllegalArgumentException("Wrong field index.");
            }
            
            result = tuple.getObject(startField + fieldIndex);
            
            wasNull = tuple.wasNull();

            return result;
        }
    }

    protected static class ConcatTuple extends Tuple
    {
        protected Tuple tuple1;
        protected Tuple tuple2;

        protected int fieldCount1;
        protected int fieldCount2;

        public ConcatTuple(Tuple tuple1, Tuple tuple2)
        {
            this.tuple1 = tuple1;
            this.tuple2 = tuple2;
            this.fieldCount1 = tuple1.getFieldCount();
            this.fieldCount2 = tuple2.getFieldCount();
        }

        public int getFieldCount()
        {
            return fieldCount1 + fieldCount2;
        }

        public Object getObject(int fieldIndex)
        {
            Object o;
        
            if (fieldIndex < fieldCount1) {
                o = tuple1.getObject(fieldIndex);
                wasNull = tuple1.wasNull();
            } else {
                o = tuple2.getObject(fieldIndex - fieldCount1);
                wasNull = tuple2.wasNull();
            }

            return o;
        }
    }
}
