package edu.buffalo.nsf.hippo.data.tuple;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.util.Util;

public abstract class TupleMetaData
{
    protected static Logger logger = Logger.getLogger(TupleMetaData.class);

    public final static int INTEGER    =    4;
    public final static int REAL       =    7;
    public final static int CHAR       =    1;
    public final static int VARCHAR    =   12;
    public final static int DATE       =   91;
    public final static int TIME       =   92;
    public final static int TIMESTAMP  =   93;
    public final static int NULL       =    0;
    public final static int OTHER      = 1111;

    public abstract int    getFieldCount    ();
    
    public abstract String getFieldName     (int fieldIndex);
    
    public abstract String getFieldTypeName (int fieldIndex);
    
    public abstract int    getFieldIndex    (String fieldName);

    public boolean equals(Object o) 
    {
        //        logger.debug(this + ".equals(" + o + ")");

        if (o instanceof TupleMetaData) {
            return equal(this,(TupleMetaData) o);
        } else {
            return false;
        }
    }
    

    public static boolean equal(TupleMetaData md1, TupleMetaData md2)
    {
        if (md1 == md2) {
            return true;
        } else {
            boolean result = md1.getFieldCount() == md2.getFieldCount();
            
//             for (int i = 0; result && i < md1.getFieldCount(); i++) {
                
//                 result = result && md1.getFieldType(i) == md2.getFieldType(i);

//                 result = md1.getFieldName(i).equals(md2.getFieldName(i))
//                     &&   md1.getFieldType(i) == md2.getFieldType(i)
//                     &&   md1.getFieldTypeName(i).equals(md2.getFielTypeName(i));
//            }
            
            return result;
        }
    }

    public static TupleMetaData NULL_META_DATA = null;

    public static TupleMetaData EMPTY_META_DATA = 
        new ArrayTupleMetaData(0, new String[0],  new String[0]);

    public static TupleMetaData create(Object o) 
    {
        String[] fieldName = {"UNKNOWN"};
        String[] fieldTypeName = new String[1];
        fieldTypeName[0] = o. getClass().getName();
        
        return new ArrayTupleMetaData(1,fieldName,fieldTypeName);
    }

    public static TupleMetaData create(ResultSetMetaData metaData) 
        throws SQLException
    {
        int      fieldCount     = metaData.getColumnCount();
        
        String[] fieldName      = new String    [fieldCount];
        //        int[]    fieldType      = new int       [fieldCount];
        String[] fieldTypeName  = new String    [fieldCount];


        for (int i = 0; i < fieldCount; i++) {
            fieldName[i]     = metaData.getColumnName(i+1);
            //            fieldType[i]     = metaData.getColumnType(i+1);
            fieldTypeName[i] = metaData.getColumnTypeName(i+1);
        }
        
        return create(fieldCount,fieldName,/*fieldType,*/fieldTypeName);
    }

    public static TupleMetaData create(int      fieldCount, String[] fieldName,
                                       /*int[]    fieldType,*/ String[] fieldTypeName)
    {
        return new ArrayTupleMetaData(fieldCount,fieldName,/*fieldType,*/fieldTypeName);
    }

    public static TupleMetaData getSubset(TupleMetaData metaData, int startField, int length)
    {
        return new SubsetTupleMetaData(metaData,startField,length);
    }

    public static TupleMetaData getUnion(TupleMetaData metaData1, TupleMetaData metaData2)
    {
        return new UnionTupleMetaData(metaData1,metaData2);
    }

    public String toString()
    {
        StringBuffer result = new StringBuffer("TMetaData:[");

        for (int i = 0; i < getFieldCount(); i++) {
            result.append(getFieldName(i)).append(':');
            result.append(getFieldTypeName(i)).append(',');
        }

        result.setCharAt(result.length() - 1,']');        

        return result+"]";
    }   

    protected static class ArrayTupleMetaData extends TupleMetaData
    {
        protected int       fieldCount;
        protected String[]  fieldName;
        protected Map       fieldIndex;
        //        protected int[]     fieldType;
        protected String[]  fieldTypeName;

        public ArrayTupleMetaData(int      fieldCount,
                                  String[] fieldName,
                                  //                                  int[]    fieldType,
                                  String[] fieldTypeName)
        {
            if (fieldName == null || /*fieldType == null || */fieldTypeName == null ||
                fieldName.length != fieldCount || /*fieldType.length != fieldCount ||*/
                fieldTypeName.length != fieldCount) {
                
                throw new IllegalArgumentException("Incompatible arrays lengths.");
            }

            this.fieldCount = fieldCount;
            this.fieldName = fieldName;
            //            this.fieldType = fieldType;
            this.fieldTypeName = fieldTypeName;
            
            fieldIndex = createFieldIndexMap(fieldName);
        }

        protected static Map createFieldIndexMap(String[] fieldName)
        {
            Map fieldIndex = Util.createMap(fieldName.length);

            for (int i = 0; i < fieldName.length; i++) {
                fieldIndex.put(fieldName[i],new Integer(i));
            }

            return fieldIndex;
        }

        public int getFieldCount()
        {
            return fieldCount;
        }

        protected int checkField(int fieldIndex) 
        {
            if (fieldIndex < 0 || fieldIndex > getFieldCount() - 1) {
                throw new IllegalArgumentException("Wrong field index.");
            }
      
            return fieldIndex;
        }

        public String getFieldName(int fieldIndex)
        {
            return fieldName[checkField(fieldIndex)];
        }

//         public int getFieldType(int fieldIndex)
//         {
//             return fieldType[checkField(fieldIndex)];
//         }

        public String getFieldTypeName(int fieldIndex)
        {
            return fieldTypeName[checkField(fieldIndex)];
        }

        public int getFieldIndex(String fieldName)
        {       
            try {
                return ((Integer) fieldIndex.get(fieldName)).intValue();
            } catch (NullPointerException exc) {
                throw new IllegalArgumentException("Field with name \'" + fieldName + "\' doesn't exist.");
            }
        }
    }

    protected static class SubsetTupleMetaData extends TupleMetaData
    {
        protected TupleMetaData metaData;
        protected int           startField;
        protected int           fieldCount;

        public SubsetTupleMetaData(TupleMetaData metaData, int startField, int fieldCount)
        {

            if ( (metaData.getFieldCount() < fieldCount ) || 
                 (metaData.getFieldCount() < startField + fieldCount - 1) ) {
                throw new IllegalArgumentException("Wrond field range.");
            }

            this.startField = startField;
            this.fieldCount = fieldCount;
            this.metaData   = metaData;
        }

        public int getFieldCount()
        {
            return fieldCount;
        }

        protected int checkField(int field)
        {
            if (field < 0 || field > fieldCount - 1) {
                throw new IllegalArgumentException("Wrong field index.");	    
            }

            return startField + field;
        }
      
        public String getFieldName(int field)
        {
            return metaData.getFieldName(checkField(field));
        }

//         public int getFieldType(int field)
//         {
//             return metaData.getFieldType(checkField(field));
//         }

        public String getFieldTypeName(int field)
        {
            return metaData.getFieldTypeName(checkField(field));
        }

        public int getFieldIndex(String fieldName)
        {
            int fieldIndex = metaData.getFieldIndex(fieldName);

            if ( (fieldIndex < startField) || (fieldIndex > startField + fieldCount - 1) ) {
                throw new IllegalArgumentException("Field with name \'" + fieldName + "\' doesn't exist.");
            } 

            return fieldIndex - startField;
        }
    }

    protected static class UnionTupleMetaData extends TupleMetaData
    {
        protected TupleMetaData metaData1;
        protected int           fieldCount1;
        protected TupleMetaData metaData2;
        protected int           fieldCount2;
    
        public UnionTupleMetaData(TupleMetaData metaData1, TupleMetaData metaData2)
        {
            this.metaData1   = metaData1;
            this.fieldCount1 = metaData1.getFieldCount();

            this.metaData2   = metaData2;
            this.fieldCount2 = metaData2.getFieldCount();

            //TODO::CONSISTENCY CHECK REQ. HERE!
        }

        public int    getFieldCount    ()
        {
            return fieldCount1 + fieldCount2;
        }
    
        public String getFieldName     (int fieldIndex)
        {
            if (fieldIndex < fieldCount1) {
                return metaData1.getFieldName(fieldIndex);
            } else {
                return metaData2.getFieldName(fieldIndex - fieldCount1);
            }
        }
    
//         public int    getFieldType     (int fieldIndex)
//         {
//             if (fieldIndex < fieldCount1) {
//                 return metaData1.getFieldType(fieldIndex);
//             } else {
//                 return metaData2.getFieldType(fieldIndex - fieldCount1);
//             }
//         }
    
        public String getFieldTypeName (int fieldIndex)
        {
            if (fieldIndex < fieldCount1) {
                return metaData1.getFieldTypeName(fieldIndex);
            } else {
                return metaData2.getFieldTypeName(fieldIndex - fieldCount1);
            }
        }
    
        public int    getFieldIndex    (String fieldName)
        {
            try {
                return metaData1.getFieldIndex(fieldName);
            } catch (IllegalArgumentException exc) {
                //ignoring
            }

            try {
                return metaData2.getFieldIndex(fieldName);
            } catch (IllegalArgumentException exc) {
                //ignoring
            }

            throw new IllegalArgumentException("Field with name \'" + fieldName + "\' doesn't exist.");
        }
    }
}
