package edu.buffalo.nsf.hippo.data.tuple;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;

public abstract class TupleStream
{
    /* Meta data */
    public abstract TupleMetaData getMetaData();
   
    /* Currsor operations */
    public abstract boolean   hasNext();
   
    /* Tuple selector  */
    public abstract Tuple     getNext();

    public static TupleStream EMPTY_TUPLE_STREAM = 
        new ListTupleStream(Collections.EMPTY_LIST,TupleMetaData.EMPTY_META_DATA);

//     public static TupleStream TRUE  = create(Tuple.EMPTY_TUPLE);
//     public static TupleStream FALSE = EMPTY_TUPLE_STREAM;

//     /**
//      *  Creates singleton.
//      */
//     public static TupleStream create(Tuple tuple)
//     {
//         if (tuple == null) {
//             throw new IllegalArgumentException("Input tuple for a singleton can not be null.");
//         }
        
//         Tuple[] tuples = new Tuple[1];
//         tuples[0] = tuple;

//         return create(tuples);
//     }

//     public static TupleStream create(Tuple[] tuples)
//     {
//         if (tuples == null || tuples.length == 0) {
//             return EMPTY_TUPLE_STREAM;
//         } else {
//             return create (Arrays.asList(tuples));
//             //TODO: ensure tuple meta data consistency.
//         }
//     }

//     public static TupleStream create(List rows) 
//     {
//         return new ListTupleStream(rows);
//     }

    public static TupleStream create(ResultSet rs) throws SQLException
    {
        return new ListTupleStream(rs);
    }

    public static TupleStream create(ResultSet rs, Statement stmt) throws SQLException
    {
        return new SQLTupleStream(rs,stmt);
    }

    public static TupleStream concatenate(TupleStream ts1, TupleStream ts2)
    {
        return new ConcatTupleStream(ts1,ts2);
    }

    public static TupleStream filter(TupleFilter f, TupleStream ts)
    {
        return new FilterTupleStream(f,ts);
    }

    public static TupleStream trim(TupleStream ts, int length)
    {
        return new TrimmingTupleStream(ts,length);
    }
}

