package edu.buffalo.nsf.hippo.net;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.EnvironmentImpl;
import edu.buffalo.nsf.hippo.XMLConfiguration;

public class ServerManager extends ThreadGroup
{

    protected static Logger logger = Logger.getLogger(ServerManager.class);


    protected Environment env;

    public ServerManager(String name)
    {
        super(name);
        this.env = new EnvironmentImpl();
    }

    public Environment getEnvironment()
    {
        return env;
    }

    public void deployServer(int port, String configFile)
        throws Exception
    {
        deployServer(port,new XMLConfiguration(configFile));
    }
    
    public void deployServer(int port, Configuration config)
        throws Exception
    {
        (new Server(this,port,config)).start();
    }

    public void shutdown()
    {
        env.shutdown();
    }
}
