package edu.buffalo.nsf.hippo.prolog;

import java.io.StringReader;
import java.util.Map;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.parser.ParseException;
import edu.buffalo.nsf.hippo.parser.QueryParser;

public abstract class AbstractProverEngine implements Engine
{
    protected Environment   env;
    protected DataSource    source;
    protected ProverFactory factory;
    protected Map           ri;
    protected QueryParser   parser;

    protected AbstractProverEngine(Environment env)
    {
        this.env = env;        
    }

    public void init(Configuration config)
    {
        source  = env.getDataSource(config);
        factory = env.getProverFactory(config);
        ri      = config.getResultInterpretation();        
    }

    protected Query parseQuery(String query)
        throws ParseException
    {
        if (parser == null) {
            parser = new QueryParser(new StringReader(query));
        } else {
            parser.ReInit(new StringReader(query));
        }

        return parser.parseQuery();
    }


    public void shutdown()
    {
        env.dispose(factory);
        env.dispose(source);
    }

    public abstract TupleStream getConsistentAnswer(String sqlQuery) throws ParseException;
}
