package edu.buffalo.nsf.hippo.prolog;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.query.OuterJoin;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTransformer;
import edu.buffalo.nsf.hippo.data.tuple.TupleFilter;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;
import edu.buffalo.nsf.hippo.parser.ParseException;

public class EnvelopeProverEngine extends AbstractProverEngine
{
    protected Logger logger = Logger.getLogger(EnvelopeProverEngine.class);

    protected QueryTransformer f;

    public EnvelopeProverEngine(Environment env)
    {
        super(env);
    }

    public void init(Configuration config)
    {
        super.init(config);
        this.f = env.getEnvelopeOperator(config);
        
        logger.debug("Has foloowing RI: " +ri);
    }

    public void shutdown()
    {
        env.dispose(f);
        super.shutdown();
    }

    public TupleStream getConsistentAnswer(String sqlQuery) throws ParseException
    {
        Query       q        = parseQuery(sqlQuery);
        Query       fq       = f.transform(q);
        TupleStream envelope = source.executeQuery(fq);


        if (fq instanceof OuterJoin) {
            OuterJoin Fq = (OuterJoin) fq;
            
            Query           sq = new OuterJoin(q,Fq.length,Fq.rel,Fq.offset);
            Prover           p = factory.create(sq); 
            TupleFilter     pf = new ProverTupleFilter(p,ri);
            TupleStream result = TupleStream.trim(TupleStream.filter(pf,envelope),Fq.length);

            return result;
        }  else {
            Prover           p = factory.create(q); 
            TupleFilter     pf = new ProverTupleFilter(p,ri);
            TupleStream result = TupleStream.filter(pf,envelope);

            return result;
        }
    }
}
