package edu.buffalo.nsf.hippo.prolog;

import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.formula.Formula;
import edu.buffalo.nsf.hippo.data.graph.ExternalHypergraphExtention;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTranslator;


public final class HProverFactory extends ProverFactory
{
    protected static Logger logger = Logger.getLogger(HProverFactory.class);

    protected Environment env;
    protected Map         schema;
    protected DataSource  source;
    protected Hypergraph  internal;
    protected Hypergraph  h;

    protected QueryTranslator trans;

    public HProverFactory(Environment env)
    {
        this.env   = env;
    }

    public void init(Configuration config)
    {
        this.schema   = config.getSchema();
        this.source   = env.getDataSource(config);
        this.internal = source.getHypergraph();
        this.h        = new ExternalHypergraphExtention(internal,source);

        this.trans    = env.getTranslator(config);
    }

    public void shutdown()
    {
        env.dispose(trans);
        env.dispose(source);        
    }
    
    public Prover create(Query q)
    {
        Formula f = trans.translate(q);

        return new HProver(f,new ProverEnv(h));
    }
}
