package edu.buffalo.nsf.hippo.prolog;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.CachedDataSource;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.DataSourceCache;
import edu.buffalo.nsf.hippo.data.graph.ExternalHypergraphExtention;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.traverse.KnowledgeHarvester;
import edu.buffalo.nsf.hippo.data.tuple.Tuple;


public final class KGProver extends Prover
{
    protected static Logger logger = Logger.getLogger(KGProver.class);

    protected KnowledgeHarvester hr;
    protected DataSource s;
    protected Hypergraph h;
    protected Prover p;
    protected ProverFactory pf;
    protected Query q;
    
    public KGProver(KnowledgeHarvester hr, 
                    DataSource s, 
                    Hypergraph h,
                    Prover p, 
                    Query q)
    {
        this.hr = hr;
        this.s = s;
        this.h = h;
        this.p = p;
        this.q = q;
    }

    public Elaboration elaborate(ProverEnv env, Tuple t)
    {
        return elaborate(t);
    }

    public Elaboration elaborate(Tuple t)
    {
        DataSourceCache c = hr.gather(q,t);

        DataSource cs = new CachedDataSource(s,c);
        
        Hypergraph eh = new ExternalHypergraphExtention(h,cs);


        return p.elaborate(new ProverEnv(eh),t);
    }

    public String toString()
    {
        return "KG[Q=" + q + "]";
    }
}
