package edu.buffalo.nsf.hippo.prolog;

import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.DataSource;
import edu.buffalo.nsf.hippo.data.graph.ExternalHypergraphExtention;
import edu.buffalo.nsf.hippo.data.graph.Hypergraph;
import edu.buffalo.nsf.hippo.data.query.Query;
import edu.buffalo.nsf.hippo.data.query.traverse.KnowledgeHarvester;
import edu.buffalo.nsf.hippo.data.query.traverse.QueryTranslator;


public final class KGProverFactory extends ProverFactory
{
    protected static Logger logger = Logger.getLogger(KGProverFactory.class);

    protected Environment env;
    protected KnowledgeHarvester hr;

    protected Map         schema;
    protected DataSource  source;
    protected Hypergraph  internal;
    protected Hypergraph  h;

    protected QueryTranslator trans;
    protected ProverFactory   pf;

    public KGProverFactory(Environment env)
    {
        this.env   = env;
        hr = new KnowledgeHarvester(env);
        pf = new HProverFactory(env);
    }

    public void init(Configuration config)
    {
        this.schema   = config.getSchema();
        this.source   = env.getDataSource(config);
        this.internal = source.getHypergraph();
        this.h        = new ExternalHypergraphExtention(internal,source);

        this.trans    = env.getTranslator(config);
        this.hr.init(config);
        this.pf.init(config);
    }

    public void shutdown()
    {
        hr.shutdown();
        pf.shutdown();
        env.dispose(trans);
        env.dispose(source);        
    }
    
    public Prover create(Query q)
    {
        return new KGProver(hr,source,h,pf.create(q),q);
    }
}
