package edu.buffalo.nsf.hippo.prolog;

import java.util.Map;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleFilter;


public class ProverTupleFilter implements TupleFilter
{
    protected static Logger logger = Logger.getLogger(ProverTupleFilter.class);

    protected Map    ri;
    protected Prover p;

    /**
     *  @param p - a prover that will elaborate on a tuple.
     *  @param ri - result interpretation -- a map from 
     *              possible results into Boolean encapsultaing
     *              the value that will be returned by method check.
     */
    public ProverTupleFilter(Prover p, Map ri)
    {
        this.p  = p;
        this.ri = ri;
    }

    public boolean check(Tuple t)
    {

        Boolean r = (Boolean) ri.get(p.elaborate(t));

        return r.booleanValue();
        //return ((Boolean) ri.get(p.elaborate(t))).booleanValue();
    }

    public String toString()
    {
        return "ProverTF:[ri=" + ri + ", p=" + p + "]";
    }
}
