package edu.buffalo.nsf.hippo.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.WindowConstants;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.Engine;
import edu.buffalo.nsf.hippo.Environment;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;


/**
* This code was generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* *************************************
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED
* for this machine, so Jigloo or this code cannot be used legally
* for any corporate or commercial purpose.
* *************************************
*/
public class SessionFrame extends javax.swing.JInternalFrame 
	implements ActionListener, TableModelListener{

	{
		//Set Look & Feel
		try {
			javax.swing.UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
		} catch(Exception e) {
			e.printStackTrace();
		}
	}


	private static Logger logger = Logger.getLogger(SessionFrame.class);
	private Environment   env;
	private Engine        engine;
	private ComboBoxModel queryHistory;
	private Configuration config;
	private TupleStreamTableModel queryResult; 
	private TableCellRenderer tableColorer;
	
	private JComboBox inputComboBox;
	private JTable outputTable;
	private JScrollPane mainScrollPane;
	private JButton runButton;
	private JButton nextPageButton;
	private JSeparator separator2;
	private JSeparator separator1;
	/**
	* Auto-generated main method to display this 
	* JInternalFrame inside a new JFrame.
	*/
	public static void main(String[] args) {
		JFrame frame = new JFrame();
		SessionFrame inst = new SessionFrame(null,null,null);
		JDesktopPane jdp = new JDesktopPane();
		jdp.add(inst);
		jdp.setPreferredSize(inst.getPreferredSize());
		frame.setContentPane(jdp);
		frame.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
		frame.pack();
		frame.setVisible(true);
	}
	
	public SessionFrame(Configuration config, Environment env, QueryHistory queryHistory) {
		super(config.getDBName() + "#" + config.getEngineName(),true,true,true,true);
		this.env = env;
		this.config = config;
		this.engine = env.getEngine(config);
		this.queryResult = new TupleStreamTableModel(10);
		this.queryResult.addTableModelListener(this);
		this.queryHistory = queryHistory;
		initGUI();
	}
	
	private void initGUI() {
		try {
			this.setPreferredSize(new java.awt.Dimension(630, 340));
			this.setBounds(0, 0, 630, 340);
			GridBagLayout thisLayout = new GridBagLayout();
			thisLayout.columnWeights = new double[] {0.1,0.1,0.1,0.1,0.1,0.1};
			thisLayout.columnWidths = new int[] {7,7,7,7,7,7};
			thisLayout.rowWeights = new double[] {0.1,0.0,0.0,0.0,0.0};
			thisLayout.rowHeights = new int[] {7,7,7,7,7};
			this.getContentPane().setLayout(thisLayout);
			setVisible(true);
			this.setAutoscrolls(true);
			thisLayout.columnWeights = new double[] {0.0,0.0,0.0,0.0,0.1,0.0};
			{
				inputComboBox = new JComboBox();
				this.getContentPane().add(
					inputComboBox,
					new GridBagConstraints(
						0,
						4,
						5,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.BOTH,
						new Insets(0, 0, 0, 0),
						0,
						0));
				inputComboBox.setModel(queryHistory);
				inputComboBox.setEditable(true);
				inputComboBox.addActionListener(this);
			}
			{
				separator1 = new JSeparator();
				this.getContentPane().add(
					separator1,
					new GridBagConstraints(
						0,
						1,
						6,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.HORIZONTAL,
						new Insets(0, 0, 0, 0),
						0,
						0));
			}
			{
				separator2 = new JSeparator();
				this.getContentPane().add(
					separator2,
					new GridBagConstraints(
						0,
						3,
						6,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.HORIZONTAL,
						new Insets(0, 0, 0, 0),
						0,
						0));
			}
			{
				nextPageButton = new JButton();
				this.getContentPane().add(
					nextPageButton,
					new GridBagConstraints(
						0,
						2,
						1,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.NONE,
						new Insets(0, 0, 0, 0),
						0,
						0));
				nextPageButton.setText("Next Page");
				nextPageButton.setEnabled(false);
				nextPageButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
						nextPageButtonActionPerformed(evt);
					}
				});
			}
			{
				runButton = new JButton();
				this.getContentPane().add(
					runButton,
					new GridBagConstraints(
						5,
						4,
						1,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.NONE,
						new Insets(0, 0, 0, 0),
						0,
						0));
				runButton.setText("Run");
				runButton.setMnemonic(java.awt.event.KeyEvent.VK_ENTER);
				runButton.addActionListener(new ActionListener() {
					public void actionPerformed(ActionEvent evt) {
						runButtonActionPerformed(evt);
					}
				});
			}
			{
				mainScrollPane = new JScrollPane();
				this.getContentPane().add(
					mainScrollPane,
					new GridBagConstraints(
						0,
						0,
						6,
						1,
						0.0,
						0.0,
						GridBagConstraints.CENTER,
						GridBagConstraints.BOTH,
						new Insets(0, 0, 0, 0),
						0,
						0));
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void runButtonActionPerformed(ActionEvent evt) {
		String query = inputComboBox.getSelectedItem().toString();

		System.out.println("Query:" + query);
		try {
			TupleStream ts = engine.getConsistentAnswer(query);
			queryResult.load(ts);		
		} catch (Throwable t) {
			logger.error("Error executing query: " + query,t);
			JOptionPane.showMessageDialog(this,
			    "Error executing the query. \n" +
				"You can find details in the log file.",
			    "Engine Error",
			    JOptionPane.ERROR_MESSAGE);			
		}
	}

	public void tableChanged(TableModelEvent arg0) {
		System.out.println("Table changed:" +arg0);
		outputTable = new JTable();		
		outputTable.setModel(queryResult);
		//outputTable.setV
		mainScrollPane.setViewportView(outputTable);
		nextPageButton.setEnabled(queryResult.isShiftable());
	}
	
	private void nextPageButtonActionPerformed(ActionEvent evt) {
		queryResult.shiftBuffer();
	}

	public void actionPerformed(ActionEvent event) {
		System.out.println("Event:" + event);
		if (event.getSource() == queryHistory) {
			
		}
	}

}
