/*
 * Created on Mar 16, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package edu.buffalo.nsf.hippo.swing;

import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

import edu.buffalo.nsf.hippo.data.tuple.Tuple;
import edu.buffalo.nsf.hippo.data.tuple.TupleMetaData;
import edu.buffalo.nsf.hippo.data.tuple.TupleStream;

/**
 * @author staworko
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TupleStreamTableModel extends AbstractTableModel {
	
	private static final long serialVersionUID = 983162142938215375L;
	protected TupleStream ts;
	protected TupleMetaData meta;
	protected Object[][]    buffer;
	protected int           fieldCount;
	protected int           bufferSize;
	protected int           pageSize;
	

	public TupleStreamTableModel(int pageSize){
		this.pageSize = pageSize;
		this.bufferSize = 0;
		this.fieldCount = 0;
	}
	
	public void load(TupleStream ts){
		this.ts   = ts;
		this.meta = ts.getMetaData(); 
		this.fieldCount  = meta.getFieldCount();
		this.buffer = new Object[pageSize][];
		for (int i = 0; i < pageSize; i++) {
			buffer[i] = new Object[fieldCount];
		}
		shiftBuffer();
	}
	
	public boolean isShiftable() {
		return ts.hasNext();
	}
	
	public void shiftBuffer() {
		bufferSize = 0;
		while (ts.hasNext() && bufferSize < pageSize) {
			Tuple t = ts.getNext();
			for (int i = 0; i < fieldCount; i++) {
				buffer[bufferSize][i] = t.getObject(i);
			}
			bufferSize++;
		}
		
		super.fireTableChanged(new TableModelEvent(this));
	}
	
	
	public int getColumnCount() {
		return fieldCount;
	}
	
	public String getColumnName(int col) {
		return meta.getFieldName(col) + " : " + meta.getFieldTypeName(col);
	}
	public int getRowCount() {
		return bufferSize;
	}

	public Object getValueAt(int row, int col) {
		if (buffer[row][col] == null) {
			return "NULL";
		} else {
			return buffer[row][col];
		}
	}

	public String toString() {
		String res = "TupleStreamTableModel[" + meta + "]={";
		for (int i = 0; i < bufferSize; i++) {
			res += "(";
			for (int j = 0; j < fieldCount; j++) {
				res += buffer[i][j] + ",";
			}
			res += "),"; 
		}
		return res + "}";
	}	
}
