package edu.buffalo.nsf.hippo.util;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;

import org.apache.log4j.Logger;

import edu.buffalo.nsf.hippo.Configuration;
import edu.buffalo.nsf.hippo.data.config.Bind;
import edu.buffalo.nsf.hippo.data.config.DenialConstraint;
import edu.buffalo.nsf.hippo.data.config.Field;
import edu.buffalo.nsf.hippo.data.config.IntegrityConstraints;
import edu.buffalo.nsf.hippo.data.config.Relation;
import edu.buffalo.nsf.hippo.data.graph.Edge;
import edu.buffalo.nsf.hippo.data.graph.Vertex;

public final class HashUtil
{
    protected static Logger logger = Logger.getLogger(HashUtil.class);

    public static boolean equalOrNull(Object o1, Object o2){
    	if (o1 == null) {
    		if (o2 == null) {
    			return true;
    		} else {
    			return o2.equals(o1);
    		}
    	} else {
    		return o1.equals(o2);    		
    	}
    }
    
    public static boolean equalEngine(Configuration c1, Configuration c2)
    {
        return c1 == c2 || (
        	   equalOrNull(c1.getEngineName(),c2.getEngineName()) &&
        	   equalOrNull(c1.getProverFactoryName(),c2.getProverFactoryName()) &&    
        	   equalOrNull(c1.getCoreSuffix(),c2.getCoreSuffix()) &&
        	   equalOrNull(c1.getTranslatorName(),c2.getTranslatorName()) &&
        	   equalOrNull(c1.getCoreOperatorName(),c2.getCoreOperatorName()) &&
        	   equalOrNull(c1.getShellOperatorName(),c2.getShellOperatorName()) &&    
        	   equalOrNull(c1.getEnvelopeOperatorName(),c2.getEnvelopeOperatorName())
            );
    }

    public static boolean equalDB(Configuration c1, Configuration c2)
    {
        return c1 == c2 || 
            (equalSchema(c1.getSchema(),c2.getSchema())
             && c1.getDBName().equals(c2.getDBName())
             && c1.getDBConnectURI().equals(c2.getDBConnectURI())
             && c1.getDBUser().equals(c2.getDBUser())
             && c1.getDBPassword().equals(c2.getDBPassword())
             && c1.getDBDriverName().equals(c2.getDBDriverName())
             && equal(c1.getIntegrityConstraints(),c2.getIntegrityConstraints()));
    }

    protected static boolean equalSchema(Map schema1, Map schema2)
    {
        Set       keySet = schema1.keySet();
        boolean   result = keySet.equals(schema2.keySet());
        Iterator  keys   = keySet.iterator();
        
        while (result && keys.hasNext()) {
            Object key = keys.next();
            Relation r1 = (Relation) schema1.get(key);
            Relation r2 = (Relation) schema2.get(key);

            result = result && equal(r1,r2);
        }
        
        return result;
    }

    protected static boolean equal(Relation r1, Relation r2)
    {
        boolean result = r1.getName().equals(r2.getName()) 
            && r1.getFieldLength() == r2.getFieldLength();

        for(int i = 0; i < r1.getFieldLength(); i++) {
            result = result && equal(r1.getField(i),r2.getField(i));
        }

        return result;
    }

    protected static boolean equal(Field f1, Field f2)
    {
        return f1.getName().equals(f2.getName()) 
            && f1.getType() == f2.getType();
    }

    protected static boolean equal(IntegrityConstraints ics1, IntegrityConstraints ics2)
    {
        boolean result = true;
        
        result = ics1.getIntegrityConstraintLength() == ics2.getIntegrityConstraintLength();

        for (int i = 0; result && i < ics1.getIntegrityConstraintLength(); i++) {
            DenialConstraint dc1 = ics1.getIntegrityConstraint(i);
            DenialConstraint dc2 = ics2.getIntegrityConstraint(i);

            result = result && equal(dc1,dc2);
        }

        return result;
    }

    protected static boolean equal(DenialConstraint dc1, DenialConstraint dc2)
    {
        boolean result = true;

        result = dc1.getBindingLength() == dc2.getBindingLength();

        for (int i = 0; result && i < dc1.getBindingLength(); i++) {
            result = result && equal(dc1.getBinding(i),dc2.getBinding(i));
        }

        result = result && dc1.getDefinition().equals(dc2.getDefinition());

        return result;
    }

    protected static boolean equal(Bind b1, Bind b2)
    {
        return b1.getRelationName().equals(b2.getRelationName()) &&
            b1.getVariableName().equals(b2.getVariableName());
    }

    protected static int hashCode(String s)
    {
        if (s == null) {
            return 0;
        } else {
            return s.hashCode();
        }
    }

    public static int hashCode(Configuration config)
    {
        return hashCode(config.getEngineName())+ 
            hashCode(config.getProverFactoryName()) + 
            hashCode(config.getCoreSuffix()) + 
            hashCode(config.getTranslatorName()) + 
            hashCode(config.getCoreOperatorName()) + 
            hashCode(config.getShellOperatorName()) +     
            hashCode(config.getEnvelopeOperatorName());
    }

    public static int hashCodeDB(Configuration config)
    {
        int hashCode = 0;

        hashCode += hashCodeSchema(config.getSchema());
        hashCode *= 512;
        
        hashCode += config.getDBName().hashCode();
        hashCode *= 512;
        
        hashCode += config.getDBConnectURI().hashCode();
        hashCode *= 512;
        
        hashCode += config.getDBUser().hashCode();
        hashCode *= 512;
        
        hashCode += config.getDBPassword().hashCode();
        hashCode *= 512;
        
        hashCode += config.getDBDriverName().hashCode();
        hashCode *= 512;
        
        hashCode += hashCode(config.getIntegrityConstraints());
        hashCode *= 512;

        return hashCode;
    }

    protected static int hashCodeSchema(Map schema)
    {
        Iterator keys = schema.keySet().iterator();
        int      hashCode = 0;
        
        while (keys.hasNext()) {
            hashCode += hashCode((Relation) schema.get(keys.next()));
            hashCode *= 32;
        }

        return hashCode;
    }

    protected static int hashCode(Relation r)
    {
        int hashCode = r.getName().hashCode() * 32;
        
        for (int i = 0; i < r.getFieldLength(); i++) {
            hashCode += hashCode(r.getField(i));
        }

        return hashCode;
    }

    protected static int hashCode(Field f)
    {
        return f.getName().hashCode() * 32 + f.getType().hashCode();
    }

    protected static int hashCode(IntegrityConstraints ics)
    {
        int hashCode = 0;
        
        for (int i = 0; i < ics.getIntegrityConstraintLength(); i++) {
            DenialConstraint dc = ics.getIntegrityConstraint(i);

            hashCode += hashCode(dc);
            hashCode *= 64;
        }

        return hashCode;
    }

    protected static int hashCode(DenialConstraint dc)
    {
        int hashCode = 0;

        for (int i = 0; i < dc.getBindingLength(); i++) {
            hashCode += hashCode(dc.getBinding(i));
            hashCode *= 64;
        }

        hashCode += dc.getDefinition().hashCode();
        hashCode *= 64;

        return hashCode;
    }

    protected static int hashCode(Bind b)
    {
        return b.getRelationName().hashCode() * 64 + b.getVariableName().hashCode();
    }
    
    public static int hashCode(Edge e)
    {
        return e.getVertices().hashCode();
    }

    public static int hashCode(Vertex v)
    {
        return v.getRelationName().hashCode() + 
            v.getTuple().hashCode();
    }
}
